<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AdPlacement;
use Illuminate\Http\Request;

class AdController extends Controller
{
    /**
     * Show all ad placements
     */
    public function index()
    {
        $placements = AdPlacement::orderBy('location')
            ->orderBy('sort_order')
            ->get();

        return view('admin.ads.index', compact('placements'));
    }

    /**
     * Update an ad placement
     */
    public function update(Request $request, AdPlacement $ad)
    {
        $request->validate([
            'ad_code' => 'nullable|string',
            'show_to' => 'required|in:all,guests,users,free_only',
            'is_active' => 'boolean',
        ]);

        $ad->update([
            'ad_code' => $request->ad_code,
            'show_to' => $request->show_to,
            'is_active' => $request->boolean('is_active'),
        ]);

        // Clear the cache
        AdPlacement::clearCache();

        return back()->with('success', "Ad placement '{$ad->display_name}' updated successfully.");
    }
}
