<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index()
    {
        $settings = [
            'about_us' => Setting::getValue('about_us', ''),
            'terms' => Setting::getValue('terms', ''),
            'privacy' => Setting::getValue('privacy', ''),
            'faq' => Setting::getValue('faq', []),
            'testimonials' => Setting::getValue('testimonials', []),
        ];

        return view('admin.settings.index', compact('settings'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'about_us' => 'nullable|string',
            'terms' => 'nullable|string',
            'privacy' => 'nullable|string',
            'faq' => 'nullable|array',
            'faq.*.question' => 'required_with:faq|string',
            'faq.*.answer' => 'required_with:faq|string',
            'testimonials' => 'nullable|array',
            'testimonials.*.name' => 'required_with:testimonials|string',
            'testimonials.*.content' => 'required_with:testimonials|string',
        ]);

        Setting::setValue('about_us', $request->about_us ?? '');
        Setting::setValue('terms', $request->terms ?? '');
        Setting::setValue('privacy', $request->privacy ?? '');
        
        if ($request->has('faq')) {
            Setting::setValue('faq', array_values(array_filter($request->faq, fn($item) => !empty($item['question']))));
        }
        
        if ($request->has('testimonials')) {
            Setting::setValue('testimonials', array_values(array_filter($request->testimonials, fn($item) => !empty($item['name']))));
        }

        return back()->with('success', 'Settings updated successfully.');
    }
}
