<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\UploadLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SystemController extends Controller
{
    public function failedJobs()
    {
        $jobs = DB::table('failed_jobs')
            ->orderByDesc('failed_at')
            ->paginate(20);

        return view('admin.system.failed-jobs', compact('jobs'));
    }

    public function retryJob($id)
    {
        $job = DB::table('failed_jobs')->find($id);
        
        if (!$job) {
            return back()->with('error', 'Job not found.');
        }

        // Re-queue the job
        DB::table('jobs')->insert([
            'queue' => 'default',
            'payload' => $job->payload,
            'attempts' => 0,
            'reserved_at' => null,
            'available_at' => now()->timestamp,
            'created_at' => now()->timestamp,
        ]);

        // Delete from failed jobs
        DB::table('failed_jobs')->delete($id);

        return back()->with('success', 'Job requeued successfully.');
    }

    public function deleteJob($id)
    {
        DB::table('failed_jobs')->delete($id);

        return back()->with('success', 'Job deleted.');
    }

    public function logs()
    {
        $logs = UploadLog::with(['user', 'schedule', 'video'])
            ->latest()
            ->paginate(50);

        return view('admin.system.logs', compact('logs'));
    }
}
