<?php

namespace App\Http\Controllers;

use App\Models\Schedule;
use App\Models\Video;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        // Today's stats
        $todayUploads = $user->videos()
            ->where('is_uploaded', true)
            ->whereDate('uploaded_at', today())
            ->count();

        // Active schedules
        $activeSchedules = $user->schedules()
            ->where('status', 'active')
            ->count();

        // Next upload time
        $nextUpload = $user->schedules()
            ->where('status', 'active')
            ->whereNotNull('next_run_at')
            ->orderBy('next_run_at')
            ->first();

        // Pending videos count
        $pendingVideos = $user->videos()
            ->where('is_uploaded', false)
            ->count();

        // Recent schedules
        $recentSchedules = $user->schedules()
            ->with(['socialAccount', 'videos'])
            ->latest()
            ->take(5)
            ->get();

        // Recent uploads
        $recentUploads = $user->videos()
            ->where('is_uploaded', true)
            ->with('schedule')
            ->latest('uploaded_at')
            ->take(5)
            ->get();

        // Plan limits
        $dailyLimit = $user->plan?->daily_upload_cap ?? 0;
        $usedQuota = $todayUploads;

        return view('dashboard.index', compact(
            'todayUploads',
            'activeSchedules',
            'nextUpload',
            'pendingVideos',
            'recentSchedules',
            'recentUploads',
            'dailyLimit',
            'usedQuota'
        ));
    }
}
