<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmailTemplate extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'subject',
        'body',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get template by name
     */
    public static function getTemplate(string $name): ?self
    {
        return static::where('name', $name)->where('is_active', true)->first();
    }

    /**
     * Parse template with user data
     */
    public function parse(array $data): array
    {
        $subject = $this->subject;
        $body = $this->body;

        foreach ($data as $key => $value) {
            $subject = str_replace("{{$key}}", $value, $subject);
            $body = str_replace("{{$key}}", $value, $body);
        }

        return [
            'subject' => $subject,
            'body' => $body,
        ];
    }

    /**
     * Available placeholders for this template type
     */
    public function getPlaceholdersAttribute(): array
    {
        return match($this->name) {
            'welcome' => ['{name}', '{email}', '{site_name}', '{login_url}'],
            'password_reset' => ['{name}', '{reset_link}', '{site_name}'],
            'promo' => ['{name}', '{promo_title}', '{promo_content}', '{site_name}', '{unsubscribe_link}'],
            default => ['{name}', '{email}', '{site_name}'],
        };
    }
}
