<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentGateway extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'display_name',
        'is_active',
        'config',
        'instructions',
        'sort_order',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'config' => 'encrypted:array',
    ];

    public static function getActive()
    {
        return static::where('is_active', true)
            ->orderBy('sort_order')
            ->get();
    }

    public static function getGateway(string $name): ?self
    {
        return static::where('name', $name)->first();
    }

    public function getConfig(string $key, $default = null)
    {
        return $this->config[$key] ?? $default;
    }

    public function getIconAttribute(): string
    {
        return match($this->name) {
            'paypal' => 'fab fa-paypal text-primary',
            'paystack' => 'fas fa-credit-card text-success',
            'flutterwave' => 'fas fa-dove text-warning',
            'skrill' => 'fas fa-wallet text-purple',
            'opay' => 'fas fa-mobile-alt text-success',
            'manual' => 'fas fa-hand-holding-usd text-info',
            default => 'fas fa-money-bill',
        };
    }
}
