<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $primaryKey = 'key';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = ['key', 'value'];

    /**
     * Get a setting value by key
     */
    public static function getValue(string $key, mixed $default = null): mixed
    {
        $setting = static::find($key);
        
        if (!$setting) {
            return $default;
        }

        // Try to decode as JSON
        $decoded = json_decode($setting->value, true);
        if (json_last_error() === JSON_ERROR_NONE) {
            return $decoded;
        }

        return $setting->value;
    }

    /**
     * Set a setting value
     */
    public static function setValue(string $key, mixed $value): void
    {
        if (is_array($value) || is_object($value)) {
            $value = json_encode($value);
        }

        static::updateOrCreate(
            ['key' => $key],
            ['value' => $value]
        );
    }

    /**
     * Get all CMS pages as array
     */
    public static function getCmsPages(): array
    {
        return [
            'about_us' => static::getValue('about_us', ''),
            'faq' => static::getValue('faq', []),
            'terms' => static::getValue('terms', ''),
            'privacy' => static::getValue('privacy', ''),
            'testimonials' => static::getValue('testimonials', []),
        ];
    }
}
