<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class SocialAccount extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'platform',
        'platform_user_id',
        'platform_user_name',
        'token',
        'refresh_token',
        'expires_at',
        'needs_reauth',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'needs_reauth' => 'boolean',
    ];

    protected $hidden = [
        'token',
        'refresh_token',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function schedules(): HasMany
    {
        return $this->hasMany(Schedule::class);
    }

    /**
     * Check if the token is expired
     */
    public function isTokenExpired(): bool
    {
        if (!$this->expires_at) {
            return false;
        }
        return $this->expires_at->isPast();
    }

    /**
     * Get the platform icon class
     */
    public function getPlatformIconAttribute(): string
    {
        return match($this->platform) {
            'youtube' => 'fab fa-youtube text-danger',
            'facebook' => 'fab fa-facebook text-primary',
            'tiktok' => 'fab fa-tiktok text-dark',
            default => 'fas fa-link',
        };
    }
}
