<?php

namespace App\Notifications;

use App\Models\Payment;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class NewPurchaseNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public Payment $payment;

    public function __construct(Payment $payment)
    {
        $this->payment = $payment;
    }

    public function via($notifiable): array
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('💰 New Subscription Purchase - $' . number_format($this->payment->amount, 2))
            ->greeting('New Purchase Alert!')
            ->line("**Customer:** {$this->payment->user->name} ({$this->payment->user->email})")
            ->line("**Plan:** {$this->payment->plan->name}")
            ->line("**Amount:** \${$this->payment->amount}")
            ->line("**Payment Method:** " . ucfirst($this->payment->payment_method))
            ->line("**Reference:** {$this->payment->reference}")
            ->action('View Payment Details', url('/admin/payments'))
            ->line('Thank you for using Updit!');
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'new_purchase',
            'payment_id' => $this->payment->id,
            'user_id' => $this->payment->user_id,
            'user_name' => $this->payment->user->name,
            'plan_name' => $this->payment->plan->name,
            'amount' => $this->payment->amount,
            'message' => "{$this->payment->user->name} purchased {$this->payment->plan->name} for \${$this->payment->amount}",
        ];
    }
}
