<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('plans', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // 'Free', 'Pro', 'Agency'
            $table->integer('max_videos_per_batch')->default(5);
            $table->integer('min_interval_minutes')->default(10);
            $table->integer('daily_upload_cap')->default(10);
            $table->string('price_id')->nullable(); // Stripe Price ID
            $table->decimal('price', 8, 2)->default(0);
            $table->text('features')->nullable(); // JSON array of features
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('plans');
    }
};
