<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('social_accounts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->enum('platform', ['youtube', 'facebook', 'tiktok']);
            $table->string('platform_user_id')->nullable(); // Channel ID
            $table->string('platform_user_name')->nullable(); // Channel Name
            $table->text('token'); // Encrypted Access Token
            $table->text('refresh_token')->nullable(); // Encrypted Refresh Token
            $table->timestamp('expires_at')->nullable();
            $table->boolean('needs_reauth')->default(false);
            $table->timestamps();
            
            $table->unique(['user_id', 'platform', 'platform_user_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('social_accounts');
    }
};
