<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('social_account_id')->constrained()->onDelete('cascade');
            
            // Settings
            $table->string('name')->nullable(); // Schedule name
            $table->enum('upload_mode', ['normal', 'shorts'])->default('normal');
            $table->integer('interval_minutes')->default(10);
            $table->boolean('auto_restart')->default(true); // 24h loop feature
            
            // State
            $table->enum('status', ['active', 'paused', 'completed', 'quota_limit'])->default('active');
            $table->integer('daily_uploaded_count')->default(0);
            $table->timestamp('next_run_at')->nullable();
            $table->timestamp('resume_at')->nullable(); // If quota hit, set to Now+24h
            $table->timestamp('last_reset_at')->nullable(); // When daily count was last reset
            
            $table->timestamps();
            
            $table->index(['status', 'next_run_at']);
            $table->index(['status', 'resume_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('schedules');
    }
};
