<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('videos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('schedule_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            
            $table->string('file_path'); // Local or S3 path
            $table->string('original_filename');
            $table->bigInteger('file_size')->default(0);
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('tags')->nullable(); // Comma-separated tags
            
            $table->boolean('is_uploaded')->default(false);
            $table->integer('upload_attempts')->default(0);
            $table->string('platform_video_id')->nullable(); // YouTube ID after success
            $table->text('upload_error')->nullable(); // Store last error
            $table->timestamp('uploaded_at')->nullable();
            
            $table->integer('sort_order')->default(0); // Order in queue
            
            $table->timestamps();
            
            $table->index(['schedule_id', 'is_uploaded', 'sort_order']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('videos');
    }
};
