<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('plans', function (Blueprint $table) {
            // Max video file size in MB (e.g., 100 = 100MB, 500 = 500MB, 2048 = 2GB)
            $table->integer('max_video_size_mb')->default(100)->after('daily_upload_cap');
            // Max total storage per user in MB (optional for future use)
            $table->integer('max_storage_mb')->default(1000)->after('max_video_size_mb');
        });
    }

    public function down(): void
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->dropColumn(['max_video_size_mb', 'max_storage_mb']);
        });
    }
};
