<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ad_placements', function (Blueprint $table) {
            $table->id();
            $table->string('name');                    // e.g., 'header_banner', 'sidebar_top'
            $table->string('display_name');            // e.g., 'Header Banner'
            $table->string('location');                // e.g., 'header', 'sidebar', 'footer', 'content'
            $table->text('ad_code')->nullable();       // HTML/JS ad code (Google AdSense, etc.)
            $table->boolean('is_active')->default(false);
            $table->string('size')->nullable();        // e.g., '728x90', '300x250'
            $table->enum('show_to', ['all', 'guests', 'users', 'free_only'])->default('all');
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ad_placements');
    }
};
