<?php

namespace Database\Seeders;

use App\Models\AdPlacement;
use Illuminate\Database\Seeder;

class AdPlacementSeeder extends Seeder
{
    public function run(): void
    {
        $placements = [
            // Header Ads
            [
                'name' => 'header_banner',
                'display_name' => 'Header Banner (Top of Page)',
                'location' => 'header',
                'size' => '728x90',
                'show_to' => 'all',
                'sort_order' => 1,
            ],
            
            // Sidebar Ads
            [
                'name' => 'sidebar_top',
                'display_name' => 'Sidebar Top',
                'location' => 'sidebar',
                'size' => '300x250',
                'show_to' => 'all',
                'sort_order' => 1,
            ],
            [
                'name' => 'sidebar_sticky',
                'display_name' => 'Sidebar Sticky (Follows scroll)',
                'location' => 'sidebar',
                'size' => '300x600',
                'show_to' => 'free_only',
                'sort_order' => 2,
            ],
            
            // Dashboard Ads (for free users)
            [
                'name' => 'dashboard_top',
                'display_name' => 'Dashboard Top Banner',
                'location' => 'dashboard',
                'size' => '728x90',
                'show_to' => 'free_only',
                'sort_order' => 1,
            ],
            [
                'name' => 'dashboard_middle',
                'display_name' => 'Dashboard Middle (Between widgets)',
                'location' => 'dashboard',
                'size' => '300x250',
                'show_to' => 'free_only',
                'sort_order' => 2,
            ],
            
            // Footer Ads
            [
                'name' => 'footer_banner',
                'display_name' => 'Footer Banner',
                'location' => 'footer',
                'size' => '728x90',
                'show_to' => 'all',
                'sort_order' => 1,
            ],
            
            // Landing Page Ads
            [
                'name' => 'landing_hero',
                'display_name' => 'Landing Page (Below Hero)',
                'location' => 'content',
                'size' => '970x90',
                'show_to' => 'guests',
                'sort_order' => 1,
            ],
            [
                'name' => 'landing_middle',
                'display_name' => 'Landing Page (Between Sections)',
                'location' => 'content',
                'size' => '728x90',
                'show_to' => 'guests',
                'sort_order' => 2,
            ],
        ];

        foreach ($placements as $placement) {
            AdPlacement::updateOrCreate(
                ['name' => $placement['name']],
                array_merge($placement, [
                    'is_active' => false, // Disabled by default until admin adds code
                    'ad_code' => null,
                ])
            );
        }
    }
}
