<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    public function run(): void
    {
        User::updateOrCreate(
            ['email' => 'admin@updit.com'],
            [
                'name' => 'Admin',
                'password' => Hash::make('admin123'),
                'role' => 'admin',
                'plan_id' => 3, // Agency plan
                'is_active' => true,
                'email_verified_at' => now(),
            ]
        );

        // Create a demo user
        User::updateOrCreate(
            ['email' => 'demo@updit.com'],
            [
                'name' => 'Demo User',
                'password' => Hash::make('demo123'),
                'role' => 'user',
                'plan_id' => 2, // Pro plan
                'is_active' => true,
                'email_verified_at' => now(),
            ]
        );
    }
}
