<?php

namespace Database\Seeders;

use App\Models\PaymentGateway;
use Illuminate\Database\Seeder;

class PaymentGatewaySeeder extends Seeder
{
    public function run(): void
    {
        $gateways = [
            [
                'name' => 'paypal',
                'display_name' => 'PayPal',
                'is_active' => false,
                'sort_order' => 1,
                'config' => [],
                'instructions' => null,
            ],
            [
                'name' => 'paystack',
                'display_name' => 'Paystack',
                'is_active' => false,
                'sort_order' => 2,
                'config' => [],
                'instructions' => null,
            ],
            [
                'name' => 'flutterwave',
                'display_name' => 'Flutterwave',
                'is_active' => false,
                'sort_order' => 3,
                'config' => [],
                'instructions' => null,
            ],
            [
                'name' => 'skrill',
                'display_name' => 'Skrill',
                'is_active' => false,
                'sort_order' => 4,
                'config' => [],
                'instructions' => null,
            ],
            [
                'name' => 'opay',
                'display_name' => 'OPay',
                'is_active' => false,
                'sort_order' => 5,
                'config' => [],
                'instructions' => null,
            ],
            [
                'name' => 'manual',
                'display_name' => 'Bank Transfer / Manual',
                'is_active' => true,
                'sort_order' => 99,
                'config' => [],
                'instructions' => "Please make a bank transfer to:\n\nBank: Example Bank\nAccount Name: Updit Inc\nAccount Number: 1234567890\n\nAfter payment, your subscription will be activated within 24 hours.",
            ],
        ];

        foreach ($gateways as $gateway) {
            PaymentGateway::updateOrCreate(
                ['name' => $gateway['name']],
                $gateway
            );
        }
    }
}
