<?php

namespace Database\Seeders;

use App\Models\Plan;
use Illuminate\Database\Seeder;

class PlanSeeder extends Seeder
{
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Free',
                'max_videos_per_batch' => 5,
                'min_interval_minutes' => 30,
                'daily_upload_cap' => 10,
                'max_video_size_mb' => 100,   // 100 MB max per video
                'max_storage_mb' => 1024,     // 1 GB total storage
                'price' => 0,
                'price_id' => null,
                'features' => [
                    '5 videos per batch',
                    '30 min minimum interval',
                    '10 uploads per day',
                    '100 MB max video size',
                    '1 GB total storage',
                    '1 connected account',
                ],
            ],
            [
                'name' => 'Pro',
                'max_videos_per_batch' => 15,
                'min_interval_minutes' => 10,
                'daily_upload_cap' => 50,
                'max_video_size_mb' => 500,   // 500 MB max per video
                'max_storage_mb' => 5120,     // 5 GB total storage
                'price' => 19.99,
                'price_id' => 'price_pro_monthly',
                'features' => [
                    '15 videos per batch',
                    '10 min minimum interval',
                    '50 uploads per day',
                    '500 MB max video size',
                    '5 GB total storage',
                    '3 connected accounts',
                    'Priority support',
                ],
            ],
            [
                'name' => 'Agency',
                'max_videos_per_batch' => 50,
                'min_interval_minutes' => 5,
                'daily_upload_cap' => 200,
                'max_video_size_mb' => 2048,  // 2 GB max per video
                'max_storage_mb' => 20480,    // 20 GB total storage
                'price' => 49.99,
                'price_id' => 'price_agency_monthly',
                'features' => [
                    '50 videos per batch',
                    '5 min minimum interval',
                    '200 uploads per day',
                    '2 GB max video size',
                    '20 GB total storage',
                    'Unlimited connected accounts',
                    'Priority support',
                    'API access',
                ],
            ],
        ];

        foreach ($plans as $plan) {
            Plan::updateOrCreate(
                ['name' => $plan['name']],
                $plan
            );
        }
    }
}
