<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    public function run(): void
    {
        $settings = [
            // Site Identity
            'site_name' => 'Updit',
            'site_tagline' => 'Automate Your YouTube Publishing',
            'site_logo' => '/images/logo.png',
            'site_favicon' => '/images/favicon.ico',
            
            // Contact Info
            'contact_email' => 'hello@updit.com',
            'contact_phone' => '+1 (555) 123-4567',
            'contact_address' => '123 Creator Street, San Francisco, CA 94105',
            
            // Social Links
            'social_twitter' => 'https://twitter.com/updit',
            'social_facebook' => 'https://facebook.com/updit',
            'social_instagram' => 'https://instagram.com/updit',
            'social_youtube' => 'https://youtube.com/@updit',
            'whatsapp_number' => '+234 903 502 6516',
            
            // Designer Credit
            'designer_name' => 'Ogasmantechs',
            'designer_whatsapp' => '+234 903 502 6516',
            
            // Hero Section
            'hero_title' => 'Automate Your YouTube Publishing',
            'hero_subtitle' => 'Upload your videos once, set your schedule, and let Updit handle the rest. Focus on creating while we handle the publishing.',
            'hero_cta' => 'Start Free Today',
            'hero_image' => '/images/hero-illustration.png',
            
            // About Section
            'about_title' => 'Why Choose Updit?',
            'about_us' => 'Updit is a powerful video scheduling platform that helps content creators automate their YouTube publishing workflow. Whether you\'re a solo creator or managing multiple channels, our platform saves you hours every week. Upload once, schedule, and let us handle the rest.',
            
            // How It Works
            'how_it_works' => json_encode([
                [
                    'step' => 1,
                    'title' => 'Connect Your Channel',
                    'description' => 'Link your YouTube account securely with OAuth. Your credentials are encrypted.',
                    'icon' => 'fa-link',
                ],
                [
                    'step' => 2,
                    'title' => 'Upload Your Videos',
                    'description' => 'Batch upload all your videos at once. Add titles, descriptions, and tags.',
                    'icon' => 'fa-cloud-upload-alt',
                ],
                [
                    'step' => 3,
                    'title' => 'Set Your Schedule',
                    'description' => 'Choose your publishing interval. From 30 minutes to daily - you decide.',
                    'icon' => 'fa-calendar-alt',
                ],
                [
                    'step' => 4,
                    'title' => 'Relax & Create',
                    'description' => 'Sit back while Updit publishes your videos automatically.',
                    'icon' => 'fa-rocket',
                ],
            ]),
            
            // Features
            'features' => json_encode([
                [
                    'title' => 'Smart Scheduling',
                    'description' => 'Set custom intervals between uploads. Perfect for drip-feeding content.',
                    'icon' => 'fa-clock',
                ],
                [
                    'title' => 'Shorts Mode',
                    'description' => 'Automatically optimize videos for YouTube Shorts with one click.',
                    'icon' => 'fa-mobile-alt',
                ],
                [
                    'title' => 'Quota Management',
                    'description' => 'Smart Restart feature handles YouTube API quotas automatically.',
                    'icon' => 'fa-sync-alt',
                ],
                [
                    'title' => 'Multi-Channel',
                    'description' => 'Manage multiple YouTube channels from a single dashboard.',
                    'icon' => 'fa-layer-group',
                ],
                [
                    'title' => 'Secure & Private',
                    'description' => 'OAuth tokens are encrypted. Your data never leaves our secure servers.',
                    'icon' => 'fa-shield-alt',
                ],
                [
                    'title' => 'Progress Tracking',
                    'description' => 'Real-time progress bars and detailed upload logs.',
                    'icon' => 'fa-chart-line',
                ],
            ]),
            
            // Terms & Privacy
            'terms' => 'By using Updit, you agree to our terms of service. We are committed to protecting your data and providing reliable video scheduling services.',
            'privacy' => 'We take your privacy seriously. Your videos and account data are securely stored and never shared with third parties.',
            
            // FAQ
            'faq' => json_encode([
                [
                    'question' => 'How does the scheduling work?',
                    'answer' => 'Upload your videos, set your preferred interval, and we\'ll automatically publish them to YouTube at the scheduled times.',
                ],
                [
                    'question' => 'What happens if YouTube quota is exceeded?',
                    'answer' => 'Our Smart Restart feature automatically pauses your schedule and resumes after 24 hours when the quota resets.',
                ],
                [
                    'question' => 'Can I upload YouTube Shorts?',
                    'answer' => 'Yes! Simply enable "Shorts Mode" when creating a schedule, and we\'ll automatically add the required #Shorts hashtag.',
                ],
                [
                    'question' => 'Is my YouTube account safe?',
                    'answer' => 'Absolutely. We use OAuth 2.0 for authentication and encrypt all tokens. We never store your password.',
                ],
                [
                    'question' => 'Can I cancel anytime?',
                    'answer' => 'Yes, you can downgrade to the free plan or cancel your subscription at any time without penalties.',
                ],
            ]),
            
            // Testimonials
            'testimonials' => json_encode([
                [
                    'name' => 'John D.',
                    'role' => 'Content Creator',
                    'content' => 'Updit saved me hours every week. Now I batch record and let the platform handle publishing.',
                    'rating' => 5,
                    'avatar' => null,
                ],
                [
                    'name' => 'Sarah M.',
                    'role' => 'Digital Marketer',
                    'content' => 'The Smart Restart feature is genius. No more worrying about quota limits!',
                    'rating' => 5,
                    'avatar' => null,
                ],
                [
                    'name' => 'Mike T.',
                    'role' => 'YouTube Educator',
                    'content' => 'Managing 3 channels used to be a nightmare. Updit made it effortless.',
                    'rating' => 5,
                    'avatar' => null,
                ],
            ]),
            
            // Footer
            'footer_text' => '© 2024 Updit. All rights reserved.',
        ];

        foreach ($settings as $key => $value) {
            Setting::setValue($key, $value);
        }
    }
}
