@extends('layouts.admin')

@section('title', 'Connected Accounts')
@section('page-title', 'Connected Accounts')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Connected Accounts</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Your Connected Accounts</h3>
                </div>
                <div class="card-body p-0">
                    @forelse($accounts as $account)
                        <div class="p-4 border-bottom d-flex align-items-center">
                            <div class="mr-4">
                                <i class="{{ $account->platform_icon }} fa-3x"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h5 class="mb-1">{{ $account->platform_user_name }}</h5>
                                <p class="text-muted mb-0">
                                    @php
                                        $colors = ['youtube' => 'danger', 'facebook' => 'primary', 'tiktok' => 'dark'];
                                    @endphp
                                    <span class="badge badge-{{ $colors[$account->platform] ?? 'secondary' }}">
                                        {{ ucfirst($account->platform) }}
                                    </span>
                                    @if($account->needs_reauth)
                                        <span class="badge badge-warning ml-2">
                                            <i class="fas fa-exclamation-triangle"></i> Needs Re-authentication
                                        </span>
                                    @else
                                        <span class="badge badge-success ml-2">Connected</span>
                                    @endif
                                </p>
                                <small class="text-muted">
                                    Connected {{ $account->created_at->diffForHumans() }}
                                    @if($account->expires_at)
                                        • Token expires {{ $account->expires_at->diffForHumans() }}
                                    @endif
                                </small>
                            </div>
                            <div>
                                @if($account->needs_reauth)
                                    <a href="{{ route("accounts.{$account->platform}.redirect") }}" class="btn btn-warning mr-2">
                                        <i class="fas fa-sync"></i> Reconnect
                                    </a>
                                @endif
                                <form action="{{ route('accounts.disconnect', $account) }}" method="POST" class="d-inline"
                                      onsubmit="return confirm('Disconnect this account? Active schedules using it will be paused.')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline-danger">
                                        <i class="fas fa-unlink"></i> Disconnect
                                    </button>
                                </form>
                            </div>
                        </div>
                    @empty
                        <div class="p-5 text-center">
                            <i class="fas fa-plug fa-4x text-muted mb-3"></i>
                            <h5>No Accounts Connected</h5>
                            <p class="text-muted">Connect your social media accounts to start scheduling videos</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-plus mr-2"></i>Connect New Account</h3>
                </div>
                <div class="card-body">
                    <p>Connect your social media accounts to enable video publishing.</p>
                    
                    @foreach($platforms as $key => $platform)
                        @if($platform['connected'])
                            <button class="btn btn-success btn-block mb-3" disabled>
                                <i class="{{ $platform['icon'] }} mr-2"></i> {{ $platform['name'] }} Connected
                                <i class="fas fa-check ml-2"></i>
                            </button>
                        @elseif($platform['configured'])
                            <a href="{{ route("accounts.{$key}.redirect") }}" class="btn btn-{{ $platform['color'] }} btn-block mb-3">
                                <i class="{{ $platform['icon'] }} mr-2"></i> Connect {{ $platform['name'] }}
                            </a>
                        @else
                            <button class="btn btn-secondary btn-block mb-3" disabled title="Not configured by admin">
                                <i class="{{ $platform['icon'] }} mr-2"></i> {{ $platform['name'] }}
                                <small>(Not Configured)</small>
                            </button>
                        @endif
                    @endforeach
                </div>
            </div>

            <div class="card card-outline card-info">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-info-circle mr-2"></i>About Permissions</h3>
                </div>
                <div class="card-body">
                    <p class="text-muted mb-0">
                        We only request the minimum permissions needed to upload videos on your behalf:
                    </p>
                    <ul class="mt-2 mb-0 text-muted">
                        <li><strong>YouTube:</strong> Upload & read channel info</li>
                        <li><strong>Facebook:</strong> Post videos to Pages</li>
                        <li><strong>TikTok:</strong> Upload & publish videos</li>
                    </ul>
                    <hr>
                    <small class="text-muted">
                        <i class="fas fa-lock"></i> Your credentials are encrypted and securely stored.
                        You can disconnect at any time.
                    </small>
                </div>
            </div>
        </div>
    </div>
@endsection
