@extends('layouts.admin')

@section('title', 'Ad Management')
@section('page-title', 'Ad Placements')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Ad Management</li>
@endsection

@section('content')
    <!-- Revenue Note -->
    <div class="row">
        <div class="col-12">
            <div class="alert alert-success">
                <h5><i class="fas fa-dollar-sign mr-2"></i>Monetization Tips</h5>
                <ul class="mb-0">
                    <li><strong>Google AdSense:</strong> Best for general traffic monetization</li>
                    <li><strong>Free users only:</strong> Show ads to free tier users to encourage upgrades</li>
                    <li><strong>Strategic placement:</strong> Dashboard and sidebar ads perform best</li>
                    <li>Paste your ad code (HTML/JavaScript) in the Ad Code field</li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Ad Placements by Location -->
    @php
        $groupedAds = $placements->groupBy('location');
        $locationLabels = [
            'header' => ['Header', 'primary', 'fa-arrow-up'],
            'sidebar' => ['Sidebar', 'info', 'fa-columns'],
            'dashboard' => ['Dashboard', 'success', 'fa-tachometer-alt'],
            'content' => ['Landing Page', 'warning', 'fa-file-alt'],
            'footer' => ['Footer', 'secondary', 'fa-arrow-down'],
        ];
    @endphp

    @foreach($groupedAds as $location => $ads)
        @php $info = $locationLabels[$location] ?? ['Other', 'dark', 'fa-ad']; @endphp
        <div class="row">
            <div class="col-12">
                <div class="card card-outline card-{{ $info[1] }}">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas {{ $info[2] }} mr-2"></i>{{ $info[0] }} Ads
                        </h3>
                        <div class="card-tools">
                            <span class="badge badge-{{ $info[1] }}">{{ $ads->where('is_active', true)->count() }} / {{ $ads->count() }} Active</span>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-striped mb-0">
                            <thead>
                                <tr>
                                    <th>Placement</th>
                                    <th>Size</th>
                                    <th>Show To</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($ads as $ad)
                                    <tr>
                                        <td>
                                            <strong>{{ $ad->display_name }}</strong>
                                            <br><small class="text-muted">{{ $ad->name }}</small>
                                        </td>
                                        <td><code>{{ $ad->size ?? 'Responsive' }}</code></td>
                                        <td>
                                            @php
                                                $showToBadges = [
                                                    'all' => 'badge-primary',
                                                    'guests' => 'badge-info',
                                                    'users' => 'badge-success',
                                                    'free_only' => 'badge-warning',
                                                ];
                                            @endphp
                                            <span class="badge {{ $showToBadges[$ad->show_to] ?? 'badge-secondary' }}">
                                                {{ ucfirst(str_replace('_', ' ', $ad->show_to)) }}
                                            </span>
                                        </td>
                                        <td>
                                            @if($ad->is_active && $ad->ad_code)
                                                <span class="badge badge-success"><i class="fas fa-check"></i> Active</span>
                                            @elseif($ad->ad_code)
                                                <span class="badge badge-warning">Disabled</span>
                                            @else
                                                <span class="badge badge-secondary">No Code</span>
                                            @endif
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-primary" 
                                                    data-toggle="modal" data-target="#adModal{{ $ad->id }}">
                                                <i class="fas fa-edit"></i> Edit
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endforeach

    <!-- Edit Modals -->
    @foreach($placements as $ad)
        <div class="modal fade" id="adModal{{ $ad->id }}" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <form action="{{ route('admin.ads.update', $ad) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="modal-content">
                        <div class="modal-header bg-primary">
                            <h5 class="modal-title"><i class="fas fa-ad mr-2"></i>{{ $ad->display_name }}</h5>
                            <button type="button" class="close text-white" data-dismiss="modal">
                                <span>&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Placement Name</label>
                                        <input type="text" class="form-control" value="{{ $ad->display_name }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Recommended Size</label>
                                        <input type="text" class="form-control" value="{{ $ad->size ?? 'Responsive' }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Show To</label>
                                        <select name="show_to" class="form-control">
                                            <option value="all" {{ $ad->show_to == 'all' ? 'selected' : '' }}>Everyone</option>
                                            <option value="guests" {{ $ad->show_to == 'guests' ? 'selected' : '' }}>Guests Only</option>
                                            <option value="users" {{ $ad->show_to == 'users' ? 'selected' : '' }}>Logged In Users</option>
                                            <option value="free_only" {{ $ad->show_to == 'free_only' ? 'selected' : '' }}>Free Plan Only</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label>Ad Code (HTML/JavaScript)</label>
                                <textarea name="ad_code" class="form-control" rows="8" 
                                          placeholder="Paste your Google AdSense or other ad code here...">{{ $ad->ad_code }}</textarea>
                                <small class="text-muted">
                                    <i class="fas fa-info-circle"></i> 
                                    Paste the complete ad code provided by your ad network (e.g., Google AdSense script tags)
                                </small>
                            </div>

                            <div class="form-group">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="active{{ $ad->id }}" 
                                           name="is_active" value="1" {{ $ad->is_active ? 'checked' : '' }}>
                                    <label class="custom-control-label" for="active{{ $ad->id }}">
                                        Enable this ad placement
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-1"></i>Save Changes
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    @endforeach
@endsection
