@extends('layouts.admin')

@section('title', 'API Keys Management')
@section('page-title', 'API Keys & Security')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.settings.index') }}">Settings</a></li>
    <li class="breadcrumb-item active">API Keys</li>
@endsection

@section('content')
    <!-- Security Notice -->
    <div class="row">
        <div class="col-12">
            <div class="alert alert-warning">
                <h5><i class="fas fa-shield-alt mr-2"></i>Security Notice</h5>
                <ul class="mb-0">
                    <li>API keys are <strong>encrypted at rest</strong> using AES-256 encryption</li>
                    <li>Keys are <strong>never logged</strong> or exposed in error messages</li>
                    <li>Only administrators can access this page</li>
                    <li>All changes are logged in the audit trail</li>
                    <li>Use <strong>test/sandbox keys</strong> during development</li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Social Platform Keys -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-share-alt mr-2"></i>Social Platform API Keys</h3>
                    <div class="card-tools">
                        <span class="badge badge-info">Stored in .env file</span>
                    </div>
                </div>
                <div class="card-body">
                    <p class="text-muted">Social platform OAuth credentials are stored in the <code>.env</code> file for security. Edit your server's <code>.env</code> file directly.</p>
                    
                    <form action="{{ route('admin.api-keys.social.update') }}" method="POST">
                        @csrf
                        
                        <!-- YouTube/Google -->
                        <div class="card card-outline card-danger mb-4">
                            <div class="card-header">
                                <h5 class="card-title"><i class="fab fa-youtube mr-2"></i>YouTube (Google)</h5>
                                <div class="card-tools">
                                    @if(!empty(config('services.google.client_id')))
                                        <span class="badge badge-success"><i class="fas fa-check"></i> Configured</span>
                                    @else
                                        <span class="badge badge-secondary">Not Configured</span>
                                    @endif
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Client ID</label>
                                            <input type="text" name="google_client_id" class="form-control" 
                                                   value="{{ config('services.google.client_id') ? '••••••••••••••••' : '' }}"
                                                   placeholder="Enter Google Client ID">
                                            <small class="text-muted">Leave blank to keep existing value</small>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Client Secret</label>
                                            <input type="password" name="google_client_secret" class="form-control" 
                                                   value=""
                                                   placeholder="Enter Google Client Secret">
                                            <small class="text-muted">Leave blank to keep existing value</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group mb-0">
                                    <label>Redirect URI (Copy to Google Console)</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" value="{{ url('/accounts/youtube/callback') }}" readonly>
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-outline-secondary" onclick="copyToClipboard(this.previousElementSibling.previousElementSibling)">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Facebook -->
                        <div class="card card-outline card-primary mb-4">
                            <div class="card-header">
                                <h5 class="card-title"><i class="fab fa-facebook mr-2"></i>Facebook</h5>
                                <div class="card-tools">
                                    @if(!empty(config('services.facebook.client_id')))
                                        <span class="badge badge-success"><i class="fas fa-check"></i> Configured</span>
                                    @else
                                        <span class="badge badge-secondary">Not Configured</span>
                                    @endif
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>App ID</label>
                                            <input type="text" name="facebook_client_id" class="form-control" 
                                                   value="{{ config('services.facebook.client_id') ? '••••••••••••••••' : '' }}"
                                                   placeholder="Enter Facebook App ID">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>App Secret</label>
                                            <input type="password" name="facebook_client_secret" class="form-control" 
                                                   placeholder="Enter Facebook App Secret">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group mb-0">
                                    <label>Redirect URI</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" value="{{ url('/accounts/facebook/callback') }}" readonly>
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-outline-secondary" onclick="copyToClipboard(this.previousElementSibling.previousElementSibling)">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- TikTok -->
                        <div class="card card-outline card-dark mb-4">
                            <div class="card-header">
                                <h5 class="card-title"><i class="fab fa-tiktok mr-2"></i>TikTok</h5>
                                <div class="card-tools">
                                    @if(!empty(config('services.tiktok.client_key')))
                                        <span class="badge badge-success"><i class="fas fa-check"></i> Configured</span>
                                    @else
                                        <span class="badge badge-secondary">Not Configured</span>
                                    @endif
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Client Key</label>
                                            <input type="text" name="tiktok_client_key" class="form-control" 
                                                   value="{{ config('services.tiktok.client_key') ? '••••••••••••••••' : '' }}"
                                                   placeholder="Enter TikTok Client Key">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Client Secret</label>
                                            <input type="password" name="tiktok_client_secret" class="form-control" 
                                                   placeholder="Enter TikTok Client Secret">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group mb-0">
                                    <label>Redirect URI</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" value="{{ url('/accounts/tiktok/callback') }}" readonly>
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-outline-secondary" onclick="copyToClipboard(this.previousElementSibling.previousElementSibling)">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert alert-info">
                            <i class="fas fa-info-circle mr-2"></i>
                            <strong>Note:</strong> After saving, you need to clear the config cache: <code>php artisan config:clear</code>
                        </div>

                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-save mr-2"></i>Save Social Platform Keys
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment Gateway Security -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-outline card-success">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-lock mr-2"></i>Payment Gateway Security</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5><i class="fas fa-shield-alt text-success mr-2"></i>Security Features Enabled</h5>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success mr-2"></i>AES-256 encryption for all API keys</li>
                                <li><i class="fas fa-check text-success mr-2"></i>Keys never exposed in logs or errors</li>
                                <li><i class="fas fa-check text-success mr-2"></i>HTTPS required for all payment callbacks</li>
                                <li><i class="fas fa-check text-success mr-2"></i>Webhook signature verification</li>
                                <li><i class="fas fa-check text-success mr-2"></i>Rate limiting on payment endpoints</li>
                                <li><i class="fas fa-check text-success mr-2"></i>CSRF protection on all forms</li>
                                <li><i class="fas fa-check text-success mr-2"></i>SQL injection prevention (Eloquent ORM)</li>
                                <li><i class="fas fa-check text-success mr-2"></i>XSS protection (Blade auto-escaping)</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h5><i class="fas fa-cog text-primary mr-2"></i>Configure Payment Gateways</h5>
                            <p>Payment gateway API keys are stored encrypted in the database and can be configured here:</p>
                            <a href="{{ route('admin.payments.gateways') }}" class="btn btn-success btn-lg">
                                <i class="fas fa-credit-card mr-2"></i>Manage Payment Gateways
                            </a>
                            
                            <hr>
                            
                            <h6>Active Gateways:</h6>
                            @php $gateways = \App\Models\PaymentGateway::where('is_active', true)->get(); @endphp
                            @forelse($gateways as $gateway)
                                <span class="badge badge-success mr-1 mb-1">
                                    <i class="{{ $gateway->icon }} mr-1"></i>{{ $gateway->display_name }}
                                </span>
                            @empty
                                <span class="text-muted">No active gateways</span>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Security Checklist -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header bg-dark">
                    <h3 class="card-title"><i class="fas fa-clipboard-check mr-2"></i>Pre-Launch Security Checklist</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <h5>Environment</h5>
                            <ul class="list-unstyled">
                                <li>
                                    @if(app()->environment('production'))
                                        <i class="fas fa-check text-success mr-2"></i>
                                    @else
                                        <i class="fas fa-exclamation-triangle text-warning mr-2"></i>
                                    @endif
                                    APP_ENV = production
                                </li>
                                <li>
                                    @if(!config('app.debug'))
                                        <i class="fas fa-check text-success mr-2"></i>
                                    @else
                                        <i class="fas fa-exclamation-triangle text-danger mr-2"></i>
                                    @endif
                                    APP_DEBUG = false
                                </li>
                                <li>
                                    @if(request()->secure() || app()->environment('local'))
                                        <i class="fas fa-check text-success mr-2"></i>
                                    @else
                                        <i class="fas fa-exclamation-triangle text-danger mr-2"></i>
                                    @endif
                                    HTTPS enabled
                                </li>
                            </ul>
                        </div>
                        <div class="col-md-4">
                            <h5>Database</h5>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success mr-2"></i>Eloquent ORM (SQL injection safe)</li>
                                <li><i class="fas fa-check text-success mr-2"></i>Encrypted columns for secrets</li>
                                <li><i class="fas fa-check text-success mr-2"></i>Password hashing (bcrypt)</li>
                            </ul>
                        </div>
                        <div class="col-md-4">
                            <h5>Application</h5>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success mr-2"></i>CSRF tokens on forms</li>
                                <li><i class="fas fa-check text-success mr-2"></i>XSS prevention (Blade)</li>
                                <li><i class="fas fa-check text-success mr-2"></i>Rate limiting enabled</li>
                                <li><i class="fas fa-check text-success mr-2"></i>Admin middleware protection</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
function copyToClipboard(input) {
    input.select();
    document.execCommand('copy');
    toastr.success('Copied to clipboard!');
}
</script>
@endsection
