@extends('layouts.admin')

@section('title', 'Active Batches')
@section('page-title', 'Upload Batch Management')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Active Batches</li>
@endsection

@section('content')
    @if(!$cronRunning)
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <h5><i class="icon fas fa-exclamation-triangle"></i> Cron Job Not Running!</h5>
            <p>The cron job hasn't run in the last 10 minutes. Scheduled uploads will not work.</p>
            <hr>
            <p class="mb-2"><strong>To fix this, add this line to your server's crontab:</strong></p>
            <code class="d-block bg-dark text-white p-2 mb-3">* * * * * cd {{ base_path() }} && php artisan schedule:run >> /dev/null 2>&1</code>
            <p class="mb-2"><strong>For cPanel, add a cron job running every 5 minutes with:</strong></p>
            <code class="d-block bg-dark text-white p-2 mb-3">cd {{ base_path() }} && php artisan schedule:run</code>
            <form action="{{ route('admin.batches.test-cron') }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-warning">
                    <i class="fas fa-play mr-2"></i>Test Cron Manually
                </button>
            </form>
        </div>
    @else
        <div class="alert alert-success">
            <i class="fas fa-check-circle mr-2"></i>
            <strong>Cron Job Running</strong> - Last run: {{ $cronLastRun ? \Carbon\Carbon::parse($cronLastRun)->diffForHumans() : 'Unknown' }}
        </div>
    @endif

    <!-- Stats -->
    <div class="row">
        <div class="col-md-4">
            <div class="info-box bg-gradient-primary">
                <span class="info-box-icon"><i class="fas fa-layer-group"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Active Batches</span>
                    <span class="info-box-number">{{ $stats['active_batches'] }}</span>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="info-box bg-gradient-warning">
                <span class="info-box-icon"><i class="fas fa-clock"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Pending Videos</span>
                    <span class="info-box-number">{{ $stats['pending_videos'] }}</span>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="info-box bg-gradient-success">
                <span class="info-box-icon"><i class="fas fa-upload"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Uploading Now</span>
                    <span class="info-box-number">{{ $stats['uploading_now'] }}</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="mb-3">
        <form action="{{ route('admin.batches.stop-all') }}" method="POST" class="d-inline">
            @csrf
            <button type="submit" class="btn btn-danger" onclick="return confirm('Stop ALL active batches?')">
                <i class="fas fa-stop-circle mr-2"></i>Stop All Batches
            </button>
        </form>
    </div>

    <!-- Active Batches -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-tasks mr-2"></i>Active Upload Batches</h3>
        </div>
        <div class="card-body p-0">
            @if($activeSchedules->count() > 0)
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Schedule</th>
                            <th>Account</th>
                            <th>Progress</th>
                            <th>Next Upload</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($activeSchedules as $schedule)
                            @php
                                $total = $schedule->videos->count();
                                $uploaded = $schedule->videos->where('is_uploaded', true)->count();
                                $progress = $total > 0 ? round(($uploaded / $total) * 100) : 0;
                            @endphp
                            <tr>
                                <td>
                                    <a href="{{ route('admin.users.show', $schedule->user) }}">
                                        {{ $schedule->user->name }}
                                    </a>
                                    <br>
                                    <small class="text-muted">{{ $schedule->user->email }}</small>
                                </td>
                                <td>
                                    {{ $schedule->name ?? 'Schedule #' . $schedule->id }}
                                    <br>
                                    <span class="badge badge-{{ $schedule->status_badge }}">{{ ucfirst($schedule->status) }}</span>
                                </td>
                                <td>
                                    @if($schedule->socialAccount)
                                        <i class="{{ $schedule->socialAccount->platform_icon }} mr-1"></i>
                                        {{ $schedule->socialAccount->platform_user_name ?? $schedule->socialAccount->platform }}
                                    @else
                                        <span class="text-muted">No account</span>
                                    @endif
                                </td>
                                <td style="width: 200px;">
                                    <div class="progress" style="height: 20px;">
                                        <div class="progress-bar bg-{{ $progress >= 100 ? 'success' : 'primary' }}" 
                                             style="width: {{ $progress }}%">
                                            {{ $uploaded }}/{{ $total }} ({{ $progress }}%)
                                        </div>
                                    </div>
                                    <small class="text-muted">
                                        Daily: {{ $schedule->daily_uploaded_count }}/{{ $schedule->user->plan->daily_upload_cap ?? '∞' }}
                                    </small>
                                </td>
                                <td>
                                    @if($schedule->next_run_at)
                                        {{ $schedule->next_run_at->format('H:i') }}
                                        <br>
                                        <small class="text-muted">{{ $schedule->next_run_at->diffForHumans() }}</small>
                                    @else
                                        <span class="text-muted">Not scheduled</span>
                                    @endif
                                </td>
                                <td>
                                    @if($schedule->status === 'active')
                                        <form action="{{ route('admin.batches.stop', $schedule) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-danger btn-sm" title="Stop">
                                                <i class="fas fa-stop"></i> Stop
                                            </button>
                                        </form>
                                    @else
                                        <form action="{{ route('admin.batches.resume', $schedule) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-success btn-sm" title="Resume">
                                                <i class="fas fa-play"></i> Resume
                                            </button>
                                        </form>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                    <p class="text-muted">No active upload batches at the moment.</p>
                </div>
            @endif
        </div>
    </div>
@endsection
