@extends('layouts.admin')

@section('title', 'Create Plan')
@section('page-title', 'Create New Plan')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.plans.index') }}">Plans</a></li>
    <li class="breadcrumb-item active">Create</li>
@endsection

@section('content')
    <div class="row justify-content-center">
        <div class="col-md-8">
            <form action="{{ route('admin.plans.store') }}" method="POST">
                @csrf
                
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-crown mr-2"></i>Plan Details</h3>
                    </div>
                    <div class="card-body">
                        @if($errors->any())
                            <div class="alert alert-danger">
                                @foreach($errors->all() as $error)
                                    {{ $error }}<br>
                                @endforeach
                            </div>
                        @endif

                        <div class="form-group">
                            <label for="name">Plan Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control" 
                                   value="{{ old('name') }}" placeholder="e.g. Pro, Business, Enterprise" required>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="price">Monthly Price ($) <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">$</span>
                                        </div>
                                        <input type="number" name="price" id="price" class="form-control" 
                                               value="{{ old('price', 0) }}" min="0" step="0.01" required>
                                    </div>
                                    <small class="text-muted">Set to 0 for a free plan</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="price_id">Stripe Price ID</label>
                                    <input type="text" name="price_id" id="price_id" class="form-control" 
                                           value="{{ old('price_id') }}" placeholder="price_xxx (optional)">
                                    <small class="text-muted">For Stripe subscription integration</small>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <h5><i class="fas fa-sliders-h mr-2"></i>Plan Limits</h5>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="max_videos_per_batch">Max Videos per Batch <span class="text-danger">*</span></label>
                                    <input type="number" name="max_videos_per_batch" id="max_videos_per_batch" 
                                           class="form-control" value="{{ old('max_videos_per_batch', 5) }}" min="1" required>
                                    <small class="text-muted">Videos uploaded per schedule</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="min_interval_minutes">Min Interval (minutes) <span class="text-danger">*</span></label>
                                    <input type="number" name="min_interval_minutes" id="min_interval_minutes" 
                                           class="form-control" value="{{ old('min_interval_minutes', 10) }}" min="1" required>
                                    <small class="text-muted">Minimum time between uploads</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="daily_upload_cap">Daily Upload Cap <span class="text-danger">*</span></label>
                                    <input type="number" name="daily_upload_cap" id="daily_upload_cap" 
                                           class="form-control" value="{{ old('daily_upload_cap', 10) }}" min="1" required>
                                    <small class="text-muted">Max videos per day</small>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <h5><i class="fas fa-list mr-2"></i>Features List</h5>
                        <p class="text-muted">Add marketing features that will be displayed on pricing page</p>

                        <div id="features-container">
                            <div class="input-group mb-2">
                                <input type="text" name="features[]" class="form-control" placeholder="e.g. Priority support">
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-danger" onclick="this.closest('.input-group').remove()">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn btn-outline-primary btn-sm" onclick="addFeature()">
                            <i class="fas fa-plus mr-1"></i>Add Feature
                        </button>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save mr-2"></i>Create Plan
                        </button>
                        <a href="{{ route('admin.plans.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    function addFeature() {
        const html = `
            <div class="input-group mb-2">
                <input type="text" name="features[]" class="form-control" placeholder="e.g. Priority support">
                <div class="input-group-append">
                    <button type="button" class="btn btn-danger" onclick="this.closest('.input-group').remove()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        `;
        document.getElementById('features-container').insertAdjacentHTML('beforeend', html);
    }
</script>
@endpush
