@extends('layouts.admin')

@section('title', 'Edit Plan')
@section('page-title', 'Edit Plan: ' . $plan->name)

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.plans.index') }}">Plans</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-8">
            <form action="{{ route('admin.plans.update', $plan) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-edit mr-2"></i>Edit Plan</h3>
                    </div>
                    <div class="card-body">
                        @if($errors->any())
                            <div class="alert alert-danger">
                                @foreach($errors->all() as $error)
                                    {{ $error }}<br>
                                @endforeach
                            </div>
                        @endif

                        <div class="form-group">
                            <label for="name">Plan Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control" 
                                   value="{{ old('name', $plan->name) }}" required>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="price">Monthly Price ($) <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">$</span>
                                        </div>
                                        <input type="number" name="price" id="price" class="form-control" 
                                               value="{{ old('price', $plan->price) }}" min="0" step="0.01" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="price_id">Stripe Price ID</label>
                                    <input type="text" name="price_id" id="price_id" class="form-control" 
                                           value="{{ old('price_id', $plan->price_id) }}" placeholder="price_xxx">
                                </div>
                            </div>
                        </div>

                        <hr>
                        <h5><i class="fas fa-sliders-h mr-2"></i>Plan Limits</h5>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="max_videos_per_batch">Max Videos per Batch</label>
                                    <input type="number" name="max_videos_per_batch" id="max_videos_per_batch" 
                                           class="form-control" value="{{ old('max_videos_per_batch', $plan->max_videos_per_batch) }}" min="1" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="min_interval_minutes">Min Interval (minutes)</label>
                                    <input type="number" name="min_interval_minutes" id="min_interval_minutes" 
                                           class="form-control" value="{{ old('min_interval_minutes', $plan->min_interval_minutes) }}" min="1" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="daily_upload_cap">Daily Upload Cap</label>
                                    <input type="number" name="daily_upload_cap" id="daily_upload_cap" 
                                           class="form-control" value="{{ old('daily_upload_cap', $plan->daily_upload_cap) }}" min="1" required>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <h5><i class="fas fa-hdd mr-2"></i>Storage & File Size Limits</h5>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle mr-2"></i>
                            Set video size limits to control Google Cloud costs. Higher-tier plans should allow larger files.
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="max_video_size_mb">Max Video File Size (MB)</label>
                                    <div class="input-group">
                                        <input type="number" name="max_video_size_mb" id="max_video_size_mb" 
                                               class="form-control" value="{{ old('max_video_size_mb', $plan->max_video_size_mb ?? 100) }}" min="10" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text">MB</span>
                                        </div>
                                    </div>
                                    <small class="text-muted">e.g., Free: 100 MB, Pro: 500 MB, Agency: 2000 MB (2 GB)</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="max_storage_mb">Max Total Storage (MB)</label>
                                    <div class="input-group">
                                        <input type="number" name="max_storage_mb" id="max_storage_mb" 
                                               class="form-control" value="{{ old('max_storage_mb', $plan->max_storage_mb ?? 1000) }}" min="100" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text">MB</span>
                                        </div>
                                    </div>
                                    <small class="text-muted">Total storage per user. 1024 MB = 1 GB</small>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <h5><i class="fas fa-list mr-2"></i>Features List</h5>

                        <div id="features-container">
                            @if($plan->features && is_array($plan->features))
                                @foreach($plan->features as $feature)
                                    <div class="input-group mb-2">
                                        <input type="text" name="features[]" class="form-control" value="{{ $feature }}">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-danger" onclick="this.closest('.input-group').remove()">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                        <button type="button" class="btn btn-outline-primary btn-sm" onclick="addFeature()">
                            <i class="fas fa-plus mr-1"></i>Add Feature
                        </button>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save mr-2"></i>Update Plan
                        </button>
                        <a href="{{ route('admin.plans.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </div>
            </form>
        </div>

        <div class="col-md-4">
            <!-- Plan Stats -->
            <div class="card card-info">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-chart-pie mr-2"></i>Plan Statistics</h3>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Active Users</span>
                            <strong>{{ $plan->users()->count() }}</strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Created</span>
                            <strong>{{ $plan->created_at->format('M d, Y') }}</strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span>Monthly Revenue</span>
                            <strong class="text-success">${{ number_format($plan->price * $plan->users()->count(), 2) }}</strong>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Danger Zone -->
            @if($plan->users()->count() == 0)
                <div class="card card-danger">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-exclamation-triangle mr-2"></i>Danger Zone</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.plans.destroy', $plan) }}" method="POST"
                              onsubmit="return confirm('Permanently delete this plan?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-block">
                                <i class="fas fa-trash mr-2"></i>Delete Plan
                            </button>
                        </form>
                    </div>
                </div>
            @else
                <div class="alert alert-warning">
                    <i class="fas fa-info-circle mr-2"></i>
                    This plan has {{ $plan->users()->count() }} active users and cannot be deleted.
                </div>
            @endif
        </div>
    </div>
@endsection

@push('scripts')
<script>
    function addFeature() {
        const html = `
            <div class="input-group mb-2">
                <input type="text" name="features[]" class="form-control" placeholder="e.g. Priority support">
                <div class="input-group-append">
                    <button type="button" class="btn btn-danger" onclick="this.closest('.input-group').remove()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        `;
        document.getElementById('features-container').insertAdjacentHTML('beforeend', html);
    }
</script>
@endpush
