@extends('layouts.admin')

@section('title', 'Manage Plans')
@section('page-title', 'Subscription Plans')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Plans</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-crown mr-2"></i>All Plans</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.plans.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus mr-2"></i>Create New Plan
                        </a>
                    </div>
                </div>
                <div class="card-body p-0">
                    <table class="table table-hover table-striped">
                        <thead>
                            <tr>
                                <th>Plan Name</th>
                                <th>Price</th>
                                <th>Videos/Batch</th>
                                <th>Min Interval</th>
                                <th>Daily Cap</th>
                                <th>Users</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($plans as $plan)
                                <tr>
                                    <td>
                                        <strong>{{ $plan->name }}</strong>
                                        @if($plan->price == 0)
                                            <span class="badge badge-success ml-2">Free</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($plan->price > 0)
                                            <span class="text-success font-weight-bold">${{ number_format($plan->price, 2) }}/mo</span>
                                        @else
                                            <span class="text-muted">Free</span>
                                        @endif
                                    </td>
                                    <td>{{ $plan->max_videos_per_batch }}</td>
                                    <td>{{ $plan->min_interval_minutes }} min</td>
                                    <td>{{ $plan->daily_upload_cap }} videos</td>
                                    <td>
                                        <span class="badge badge-info">{{ $plan->users_count }} users</span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('admin.plans.edit', $plan) }}" class="btn btn-info" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @if($plan->users_count == 0)
                                                <form action="{{ route('admin.plans.destroy', $plan) }}" method="POST" class="d-inline"
                                                      onsubmit="return confirm('Delete this plan?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger" title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Plan Features Summary -->
    <div class="row">
        @foreach($plans as $plan)
            <div class="col-md-4">
                <div class="card card-outline {{ $plan->price == 0 ? 'card-secondary' : ($plan->price > 30 ? 'card-warning' : 'card-primary') }}">
                    <div class="card-header text-center">
                        <h3 class="card-title">{{ $plan->name }}</h3>
                    </div>
                    <div class="card-body text-center">
                        <h1 class="mb-0">
                            @if($plan->price > 0)
                                ${{ number_format($plan->price, 0) }}
                            @else
                                Free
                            @endif
                        </h1>
                        @if($plan->price > 0)
                            <small class="text-muted">per month</small>
                        @endif
                        
                        <hr>
                        
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success mr-2"></i>{{ $plan->max_videos_per_batch }} videos per batch</li>
                            <li><i class="fas fa-check text-success mr-2"></i>{{ $plan->min_interval_minutes }} min minimum interval</li>
                            <li><i class="fas fa-check text-success mr-2"></i>{{ $plan->daily_upload_cap }} daily uploads</li>
                            @if($plan->features && is_array($plan->features))
                                @foreach($plan->features as $feature)
                                    <li><i class="fas fa-check text-success mr-2"></i>{{ $feature }}</li>
                                @endforeach
                            @endif
                        </ul>
                        
                        <div class="mt-3">
                            <span class="badge badge-info">{{ $plan->users_count }} active users</span>
                        </div>
                    </div>
                    <div class="card-footer text-center">
                        <a href="{{ route('admin.plans.edit', $plan) }}" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-edit mr-1"></i>Edit Plan
                        </a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endsection
