@extends('layouts.admin')

@section('title', 'CMS Settings')
@section('page-title', 'CMS & Page Editor')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Settings</li>
@endsection

@section('content')
    <form action="{{ route('admin.settings.update') }}" method="POST">
        @csrf
        @method('PUT')

        <div class="row">
            <div class="col-md-6">
                <!-- About Us -->
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">About Us</h3>
                    </div>
                    <div class="card-body">
                        <textarea name="about_us" rows="6" class="form-control">{{ $settings['about_us'] }}</textarea>
                    </div>
                </div>

                <!-- Terms -->
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">Terms of Service</h3>
                    </div>
                    <div class="card-body">
                        <textarea name="terms" rows="6" class="form-control">{{ $settings['terms'] }}</textarea>
                    </div>
                </div>

                <!-- Privacy -->
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">Privacy Policy</h3>
                    </div>
                    <div class="card-body">
                        <textarea name="privacy" rows="6" class="form-control">{{ $settings['privacy'] }}</textarea>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <!-- FAQ -->
                <div class="card card-info card-outline">
                    <div class="card-header">
                        <h3 class="card-title">FAQ</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-sm btn-info" onclick="addFaq()">
                                <i class="fas fa-plus"></i> Add FAQ
                            </button>
                        </div>
                    </div>
                    <div class="card-body" id="faqContainer">
                        @forelse($settings['faq'] as $index => $faq)
                            <div class="faq-item border rounded p-3 mb-3">
                                <div class="form-group">
                                    <label>Question</label>
                                    <input type="text" name="faq[{{ $index }}][question]" 
                                           class="form-control" value="{{ $faq['question'] }}">
                                </div>
                                <div class="form-group mb-0">
                                    <label>Answer</label>
                                    <textarea name="faq[{{ $index }}][answer]" rows="2" 
                                              class="form-control">{{ $faq['answer'] }}</textarea>
                                </div>
                                <button type="button" class="btn btn-sm btn-danger mt-2" onclick="this.closest('.faq-item').remove()">
                                    <i class="fas fa-trash"></i> Remove
                                </button>
                            </div>
                        @empty
                            <p class="text-muted text-center">No FAQs yet. Click "Add FAQ" to create one.</p>
                        @endforelse
                    </div>
                </div>

                <!-- Testimonials -->
                <div class="card card-success card-outline">
                    <div class="card-header">
                        <h3 class="card-title">Testimonials</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-sm btn-success" onclick="addTestimonial()">
                                <i class="fas fa-plus"></i> Add
                            </button>
                        </div>
                    </div>
                    <div class="card-body" id="testimonialContainer">
                        @forelse($settings['testimonials'] as $index => $testimonial)
                            <div class="testimonial-item border rounded p-3 mb-3">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label>Name</label>
                                            <input type="text" name="testimonials[{{ $index }}][name]" 
                                                   class="form-control" value="{{ $testimonial['name'] }}">
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label>Role</label>
                                            <input type="text" name="testimonials[{{ $index }}][role]" 
                                                   class="form-control" value="{{ $testimonial['role'] ?? '' }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group mb-0">
                                    <label>Content</label>
                                    <textarea name="testimonials[{{ $index }}][content]" rows="2" 
                                              class="form-control">{{ $testimonial['content'] }}</textarea>
                                </div>
                                <button type="button" class="btn btn-sm btn-danger mt-2" onclick="this.closest('.testimonial-item').remove()">
                                    <i class="fas fa-trash"></i> Remove
                                </button>
                            </div>
                        @empty
                            <p class="text-muted text-center">No testimonials yet.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>

        <div class="text-center mb-4">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fas fa-save mr-2"></i>Save All Settings
            </button>
        </div>
    </form>
@endsection

@push('scripts')
<script>
    let faqIndex = {{ count($settings['faq']) }};
    let testimonialIndex = {{ count($settings['testimonials']) }};

    function addFaq() {
        const html = `
            <div class="faq-item border rounded p-3 mb-3">
                <div class="form-group">
                    <label>Question</label>
                    <input type="text" name="faq[${faqIndex}][question]" class="form-control" placeholder="Enter question">
                </div>
                <div class="form-group mb-0">
                    <label>Answer</label>
                    <textarea name="faq[${faqIndex}][answer]" rows="2" class="form-control" placeholder="Enter answer"></textarea>
                </div>
                <button type="button" class="btn btn-sm btn-danger mt-2" onclick="this.closest('.faq-item').remove()">
                    <i class="fas fa-trash"></i> Remove
                </button>
            </div>
        `;
        document.getElementById('faqContainer').insertAdjacentHTML('beforeend', html);
        faqIndex++;
    }

    function addTestimonial() {
        const html = `
            <div class="testimonial-item border rounded p-3 mb-3">
                <div class="row">
                    <div class="col-6">
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" name="testimonials[${testimonialIndex}][name]" class="form-control" placeholder="John Doe">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label>Role</label>
                            <input type="text" name="testimonials[${testimonialIndex}][role]" class="form-control" placeholder="Content Creator">
                        </div>
                    </div>
                </div>
                <div class="form-group mb-0">
                    <label>Content</label>
                    <textarea name="testimonials[${testimonialIndex}][content]" rows="2" class="form-control" placeholder="Testimonial content..."></textarea>
                </div>
                <button type="button" class="btn btn-sm btn-danger mt-2" onclick="this.closest('.testimonial-item').remove()">
                    <i class="fas fa-trash"></i> Remove
                </button>
            </div>
        `;
        document.getElementById('testimonialContainer').insertAdjacentHTML('beforeend', html);
        testimonialIndex++;
    }
</script>
@endpush
