@extends('layouts.admin')

@section('title', 'Setup Guide')
@section('page-title', 'Platform Setup Guide')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Setup Guide</li>
@endsection

@section('content')
    <!-- Quick Action -->
    <div class="row">
        <div class="col-12">
            <div class="callout callout-success">
                <h5><i class="fas fa-rocket mr-2"></i>Quick Setup</h5>
                <p class="mb-2">Get your platform credentials from the developer portals below, then add them using the API Keys page:</p>
                <a href="{{ route('admin.api-keys.index') }}" class="btn btn-success btn-lg">
                    <i class="fas fa-key mr-2"></i>Configure API Keys
                </a>
            </div>
        </div>
    </div>

    <!-- Platform Status -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header bg-primary">
                    <h3 class="card-title"><i class="fas fa-server mr-2"></i>Platform Status</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="info-box {{ !empty(config('services.google.client_id')) ? 'bg-success' : 'bg-secondary' }}">
                                <span class="info-box-icon"><i class="fab fa-youtube"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">YouTube</span>
                                    <span class="info-box-number">
                                        @if(!empty(config('services.google.client_id')))
                                            <i class="fas fa-check"></i> Configured
                                        @else
                                            <i class="fas fa-times"></i> Not Configured
                                        @endif
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box {{ !empty(config('services.facebook.client_id')) ? 'bg-success' : 'bg-secondary' }}">
                                <span class="info-box-icon"><i class="fab fa-facebook"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Facebook</span>
                                    <span class="info-box-number">
                                        @if(!empty(config('services.facebook.client_id')))
                                            <i class="fas fa-check"></i> Configured
                                        @else
                                            <i class="fas fa-times"></i> Not Configured
                                        @endif
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box {{ !empty(config('services.tiktok.client_key')) ? 'bg-success' : 'bg-secondary' }}">
                                <span class="info-box-icon"><i class="fab fa-tiktok"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">TikTok</span>
                                    <span class="info-box-number">
                                        @if(!empty(config('services.tiktok.client_key')))
                                            <i class="fas fa-check"></i> Configured
                                        @else
                                            <i class="fas fa-times"></i> Not Configured
                                        @endif
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- YouTube Setup -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-outline card-danger collapsed-card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fab fa-youtube mr-2"></i>YouTube Setup (Google Cloud)</h3>
                    <div class="card-tools">
                        @if(!empty(config('services.google.client_id')))
                            <span class="badge badge-success mr-2">Configured</span>
                        @else
                            <span class="badge badge-warning mr-2">Setup Required</span>
                        @endif
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <h5><i class="fas fa-list-ol mr-2"></i>How to Get YouTube API Credentials</h5>
                            <ol class="mb-4">
                                <li>Go to <a href="https://console.cloud.google.com" target="_blank">Google Cloud Console</a></li>
                                <li>Create a new project (e.g., "Updit")</li>
                                <li>Navigate to <strong>APIs & Services → Library</strong></li>
                                <li>Search and enable <strong>YouTube Data API v3</strong></li>
                                <li>Go to <strong>Credentials → Create Credentials → OAuth Client ID</strong></li>
                                <li>Application type: <strong>Web application</strong></li>
                                <li>Add the redirect URI below as <strong>Authorized redirect URI</strong></li>
                                <li>Copy the <strong>Client ID</strong> and <strong>Client Secret</strong></li>
                                <li>Go to <a href="{{ route('admin.api-keys.index') }}">API Keys page</a> and paste them there</li>
                            </ol>
                        </div>
                        <div class="col-md-4">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6><i class="fas fa-link mr-2"></i>Your Redirect URI</h6>
                                    <div class="input-group">
                                        <input type="text" class="form-control form-control-sm" value="{{ url('/accounts/youtube/callback') }}" readonly id="youtubeUri">
                                        <div class="input-group-append">
                                            <button class="btn btn-sm btn-outline-secondary" onclick="copyUri('youtubeUri')">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <small class="text-muted">Copy this and paste in Google Cloud Console</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Facebook Setup -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-outline card-primary collapsed-card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fab fa-facebook mr-2"></i>Facebook Setup (Meta Developer)</h3>
                    <div class="card-tools">
                        @if(!empty(config('services.facebook.client_id')))
                            <span class="badge badge-success mr-2">Configured</span>
                        @else
                            <span class="badge badge-warning mr-2">Setup Required</span>
                        @endif
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <h5><i class="fas fa-list-ol mr-2"></i>How to Get Facebook API Credentials</h5>
                            <ol class="mb-4">
                                <li>Go to <a href="https://developers.facebook.com" target="_blank">Meta Developer Portal</a></li>
                                <li>Create a new app (Type: <strong>Business</strong>)</li>
                                <li>Add <strong>Facebook Login</strong> product</li>
                                <li>Go to Facebook Login → Settings</li>
                                <li>Add the redirect URI below as <strong>Valid OAuth Redirect URI</strong></li>
                                <li>Go to <strong>App Settings → Basic</strong> to get App ID and Secret</li>
                                <li>Request permissions: <code>pages_manage_posts</code>, <code>publish_video</code></li>
                                <li>Go to <a href="{{ route('admin.api-keys.index') }}">API Keys page</a> and paste them there</li>
                            </ol>
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle mr-2"></i>
                                Facebook requires <strong>App Review</strong> before your app can be used by users other than developers/testers.
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6><i class="fas fa-link mr-2"></i>Your Redirect URI</h6>
                                    <div class="input-group">
                                        <input type="text" class="form-control form-control-sm" value="{{ url('/accounts/facebook/callback') }}" readonly id="facebookUri">
                                        <div class="input-group-append">
                                            <button class="btn btn-sm btn-outline-secondary" onclick="copyUri('facebookUri')">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <small class="text-muted">Copy this and paste in Meta Developer Portal</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- TikTok Setup -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-outline card-dark collapsed-card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fab fa-tiktok mr-2"></i>TikTok Setup</h3>
                    <div class="card-tools">
                        @if(!empty(config('services.tiktok.client_key')))
                            <span class="badge badge-success mr-2">Configured</span>
                        @else
                            <span class="badge badge-warning mr-2">Setup Required</span>
                        @endif
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <h5><i class="fas fa-list-ol mr-2"></i>How to Get TikTok API Credentials</h5>
                            <ol class="mb-4">
                                <li>Go to <a href="https://developers.tiktok.com" target="_blank">TikTok Developer Portal</a></li>
                                <li>Create a developer account</li>
                                <li>Create a new app</li>
                                <li>Request <strong>Content Posting API</strong> access</li>
                                <li>Add the redirect URI below</li>
                                <li>Copy <strong>Client Key</strong> and <strong>Client Secret</strong></li>
                                <li>Go to <a href="{{ route('admin.api-keys.index') }}">API Keys page</a> and paste them there</li>
                            </ol>
                            <div class="alert alert-danger">
                                <i class="fas fa-clock mr-2"></i>
                                TikTok Content Posting API requires <strong>manual approval</strong> which can take several days to weeks.
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6><i class="fas fa-link mr-2"></i>Your Redirect URI</h6>
                                    <div class="input-group">
                                        <input type="text" class="form-control form-control-sm" value="{{ url('/accounts/tiktok/callback') }}" readonly id="tiktokUri">
                                        <div class="input-group-append">
                                            <button class="btn btn-sm btn-outline-secondary" onclick="copyUri('tiktokUri')">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <small class="text-muted">Copy this and paste in TikTok Developer Portal</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Server Requirements -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-outline card-success">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-server mr-2"></i>Server Requirements</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5><i class="fas fa-clock mr-2"></i>Cron Job (Required)</h5>
                            <p>Add this to your server's crontab for scheduled uploads:</p>
                            <pre class="bg-dark text-light p-3 rounded"><code>* * * * * cd {{ base_path() }} && php artisan schedule:run >> /dev/null 2>&1</code></pre>
                        </div>
                        <div class="col-md-6">
                            <h5><i class="fas fa-cogs mr-2"></i>Queue Worker (Required)</h5>
                            <p>Run the queue worker to process video uploads:</p>
                            <pre class="bg-dark text-light p-3 rounded"><code>php artisan queue:work redis --daemon</code></pre>
                            <p class="text-muted">For production, use Supervisor to keep this running.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Test -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header bg-info">
                    <h3 class="card-title"><i class="fas fa-vial mr-2"></i>Testing Without API Credentials</h3>
                </div>
                <div class="card-body">
                    <p>
                        <i class="fas fa-lightbulb text-warning mr-2"></i>
                        <strong>Simulation Mode:</strong> If no API credentials are configured, the system will use 
                        <strong>simulation mode</strong> for testing. Videos will be marked as uploaded with simulated 
                        video IDs (90% success rate). This is useful for testing the workflow without real API access.
                    </p>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
function copyUri(inputId) {
    const input = document.getElementById(inputId);
    input.select();
    document.execCommand('copy');
    toastr.success('Copied to clipboard!');
}
</script>
@endsection
