@extends('layouts.admin')

@section('title', 'Subscriptions')
@section('page-title', 'Subscription Management')

@section('content')
    <!-- Revenue Stats -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>${{ number_format($stats['this_month'], 2) }}</h3>
                    <p>This Month</p>
                </div>
                <div class="icon"><i class="fas fa-calendar-alt"></i></div>
                <span class="small-box-footer">
                    @if($stats['growth'] >= 0)
                        <i class="fas fa-arrow-up"></i> {{ $stats['growth'] }}% from last month
                    @else
                        <i class="fas fa-arrow-down text-danger"></i> {{ abs($stats['growth']) }}% from last month
                    @endif
                </span>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>${{ number_format($stats['last_month'], 2) }}</h3>
                    <p>Last Month</p>
                </div>
                <div class="icon"><i class="fas fa-history"></i></div>
                <span class="small-box-footer">{{ $stats['last_month_count'] }} purchases</span>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-primary">
                <div class="inner">
                    <h3>${{ number_format($stats['total_revenue'], 2) }}</h3>
                    <p>Total Revenue</p>
                </div>
                <div class="icon"><i class="fas fa-dollar-sign"></i></div>
                <span class="small-box-footer">{{ $stats['total_purchases'] }} total purchases</span>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3>{{ $stats['active_subs'] }}</h3>
                    <p>Active Subscriptions</p>
                </div>
                <div class="icon"><i class="fas fa-users"></i></div>
                <span class="small-box-footer">{{ $stats['pending_subs'] }} pending approval</span>
            </div>
        </div>
    </div>

    <!-- Revenue Chart -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-chart-line mr-2"></i>Monthly Revenue (Last 6 Months)</h3>
                </div>
                <div class="card-body">
                    <canvas id="revenueChart" height="100"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-chart-pie mr-2"></i>Revenue by Plan</h3>
                </div>
                <div class="card-body">
                    <canvas id="planChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Purchases -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-shopping-cart mr-2"></i>All Purchases</h3>
            <div class="card-tools">
                <form action="" method="GET" class="form-inline">
                    <select name="status" class="form-control form-control-sm mr-2" onchange="this.form.submit()">
                        <option value="">All Status</option>
                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="failed" {{ request('status') == 'failed' ? 'selected' : '' }}>Failed</option>
                        <option value="refunded" {{ request('status') == 'refunded' ? 'selected' : '' }}>Refunded</option>
                    </select>
                    <input type="month" name="month" class="form-control form-control-sm" 
                           value="{{ request('month', now()->format('Y-m')) }}" onchange="this.form.submit()">
                </form>
            </div>
        </div>
        <div class="card-body p-0">
            <table class="table table-striped table-hover mb-0">
                <thead>
                    <tr>
                        <th>Reference</th>
                        <th>Customer</th>
                        <th>Plan</th>
                        <th>Amount</th>
                        <th>Method</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($payments as $payment)
                        <tr>
                            <td><code>{{ $payment->reference }}</code></td>
                            <td>
                                <a href="{{ route('admin.users.show', $payment->user) }}">
                                    {{ $payment->user->name }}
                                </a>
                                <br><small class="text-muted">{{ $payment->user->email }}</small>
                            </td>
                            <td>
                                <span class="badge badge-primary">{{ $payment->plan->name ?? 'N/A' }}</span>
                            </td>
                            <td><strong>${{ number_format($payment->amount, 2) }}</strong></td>
                            <td>
                                <i class="{{ $payment->payment_method_icon }} mr-1"></i>
                                {{ ucfirst($payment->payment_method) }}
                            </td>
                            <td>
                                <span class="badge badge-{{ $payment->status_badge }}">
                                    {{ ucfirst($payment->status) }}
                                </span>
                            </td>
                            <td>{{ $payment->created_at->format('M d, Y h:i A') }}</td>
                            <td>
                                @if($payment->status === 'pending')
                                    <form action="{{ route('admin.payments.approve', $payment) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-success" title="Approve">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    </form>
                                    <form action="{{ route('admin.payments.reject', $payment) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-danger" title="Reject">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center py-4 text-muted">
                                <i class="fas fa-inbox fa-2x mb-2"></i>
                                <p class="mb-0">No payments found for this period.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($payments->hasPages())
            <div class="card-footer">
                {{ $payments->appends(request()->query())->links() }}
            </div>
        @endif
    </div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Revenue Chart
    new Chart(document.getElementById('revenueChart'), {
        type: 'line',
        data: {
            labels: {!! json_encode($chartData['labels']) !!},
            datasets: [{
                label: 'Revenue ($)',
                data: {!! json_encode($chartData['revenue']) !!},
                borderColor: '#28a745',
                backgroundColor: 'rgba(40, 167, 69, 0.1)',
                tension: 0.3,
                fill: true
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) { return '$' + value; }
                    }
                }
            }
        }
    });

    // Plan Distribution Chart
    new Chart(document.getElementById('planChart'), {
        type: 'doughnut',
        data: {
            labels: {!! json_encode($chartData['plan_labels']) !!},
            datasets: [{
                data: {!! json_encode($chartData['plan_revenue']) !!},
                backgroundColor: ['#007bff', '#28a745', '#ffc107', '#dc3545', '#6c757d']
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { position: 'bottom' }
            }
        }
    });
</script>
@endpush
