@extends('layouts.admin')

@section('title', 'Support Tickets')
@section('page-title', 'Support Management')

@section('content')
    <!-- Stats -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-primary">
                <div class="inner">
                    <h3>{{ $stats['open'] }}</h3>
                    <p>Open Tickets</p>
                </div>
                <div class="icon"><i class="fas fa-envelope-open"></i></div>
                <a href="{{ route('admin.support.index', ['status' => 'open']) }}" class="small-box-footer">
                    View <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>{{ $stats['in_progress'] }}</h3>
                    <p>In Progress</p>
                </div>
                <div class="icon"><i class="fas fa-spinner"></i></div>
                <a href="{{ route('admin.support.index', ['status' => 'in_progress']) }}" class="small-box-footer">
                    View <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3>{{ $stats['waiting'] }}</h3>
                    <p>Awaiting Reply</p>
                </div>
                <div class="icon"><i class="fas fa-clock"></i></div>
                <a href="{{ route('admin.support.index', ['status' => 'waiting']) }}" class="small-box-footer">
                    View <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3>{{ $stats['urgent'] }}</h3>
                    <p>Urgent</p>
                </div>
                <div class="icon"><i class="fas fa-exclamation-triangle"></i></div>
                <a href="{{ route('admin.support.index', ['priority' => 'urgent']) }}" class="small-box-footer">
                    View <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Tickets Table -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-ticket-alt mr-2"></i>All Tickets</h3>
            <div class="card-tools">
                <form action="" method="GET" class="form-inline">
                    <select name="status" class="form-control form-control-sm mr-2" onchange="this.form.submit()">
                        <option value="all">All Status</option>
                        <option value="open" {{ request('status') == 'open' ? 'selected' : '' }}>Open</option>
                        <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                        <option value="waiting" {{ request('status') == 'waiting' ? 'selected' : '' }}>Waiting</option>
                        <option value="resolved" {{ request('status') == 'resolved' ? 'selected' : '' }}>Resolved</option>
                        <option value="closed" {{ request('status') == 'closed' ? 'selected' : '' }}>Closed</option>
                    </select>
                    <select name="priority" class="form-control form-control-sm" onchange="this.form.submit()">
                        <option value="">All Priority</option>
                        <option value="urgent" {{ request('priority') == 'urgent' ? 'selected' : '' }}>Urgent</option>
                        <option value="high" {{ request('priority') == 'high' ? 'selected' : '' }}>High</option>
                        <option value="medium" {{ request('priority') == 'medium' ? 'selected' : '' }}>Medium</option>
                        <option value="low" {{ request('priority') == 'low' ? 'selected' : '' }}>Low</option>
                    </select>
                </form>
            </div>
        </div>
        <div class="card-body p-0">
            @if($tickets->count() > 0)
                <table class="table table-striped table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Ticket #</th>
                            <th>User</th>
                            <th>Subject</th>
                            <th>Category</th>
                            <th>Priority</th>
                            <th>Status</th>
                            <th>Last Update</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($tickets as $ticket)
                            <tr class="{{ $ticket->priority == 'urgent' ? 'table-danger' : '' }}">
                                <td><code>{{ $ticket->ticket_number }}</code></td>
                                <td>
                                    <strong>{{ $ticket->user->name }}</strong>
                                    <br><small class="text-muted">{{ $ticket->user->email }}</small>
                                </td>
                                <td>
                                    <a href="{{ route('admin.support.show', $ticket) }}">
                                        {{ Str::limit($ticket->subject, 35) }}
                                    </a>
                                </td>
                                <td>
                                    <i class="{{ $ticket->category_icon }} mr-1"></i>
                                    {{ ucfirst($ticket->category) }}
                                </td>
                                <td>
                                    <span class="badge {{ $ticket->priority_badge }}">
                                        {{ ucfirst($ticket->priority) }}
                                    </span>
                                </td>
                                <td>
                                    <span class="badge {{ $ticket->status_badge }}">
                                        {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
                                    </span>
                                </td>
                                <td>{{ $ticket->last_reply_at?->diffForHumans() ?? '-' }}</td>
                                <td>
                                    <a href="{{ route('admin.support.show', $ticket) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    @if(!$ticket->assigned_to)
                                        <form action="{{ route('admin.support.assign', $ticket) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-success" title="Assign to me">
                                                <i class="fas fa-user-check"></i>
                                            </button>
                                        </form>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                    <p class="text-muted">No tickets found.</p>
                </div>
            @endif
        </div>
        @if($tickets->hasPages())
            <div class="card-footer">
                {{ $tickets->appends(request()->query())->links() }}
            </div>
        @endif
    </div>
@endsection
