@extends('layouts.admin')

@section('title', 'Ticket ' . $ticket->ticket_number)
@section('page-title', 'View Ticket')

@section('content')
    <div class="row">
        <div class="col-md-8">
            <!-- Ticket Info -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="{{ $ticket->category_icon }} mr-2"></i>
                        {{ $ticket->subject }}
                    </h3>
                    <div class="card-tools">
                        <span class="badge {{ $ticket->status_badge }}">
                            {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
                        </span>
                        <span class="badge {{ $ticket->priority_badge }} ml-1">
                            {{ ucfirst($ticket->priority) }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Messages -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-comments mr-2"></i>Conversation</h3>
                </div>
                <div class="card-body" style="max-height: 500px; overflow-y: auto;">
                    @foreach($ticket->messages as $message)
                        <div class="direct-chat-msg {{ $message->is_admin_reply ? 'right' : '' }} mb-3">
                            <div class="direct-chat-infos clearfix">
                                <span class="direct-chat-name {{ $message->is_admin_reply ? 'float-right' : 'float-left' }}">
                                    {{ $message->user->name }}
                                    @if($message->is_admin_reply)
                                        <span class="badge badge-primary">Staff</span>
                                    @else
                                        <span class="badge badge-secondary">User</span>
                                    @endif
                                </span>
                                <span class="direct-chat-timestamp {{ $message->is_admin_reply ? 'float-left' : 'float-right' }}">
                                    {{ $message->created_at->format('M d, Y h:i A') }}
                                </span>
                            </div>
                            <div class="direct-chat-text {{ $message->is_admin_reply ? 'bg-primary' : 'bg-light' }}" 
                                 style="{{ $message->is_admin_reply ? '' : 'color: #333;' }}">
                                {!! nl2br(e($message->message)) !!}
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Reply Form -->
            @if(!in_array($ticket->status, ['closed']))
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-reply mr-2"></i>Reply as Staff</h3>
                    </div>
                    <form action="{{ route('admin.support.reply', $ticket) }}" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="form-group">
                                <textarea name="message" class="form-control" rows="4" 
                                          placeholder="Type your reply..." required></textarea>
                            </div>
                            <div class="form-group mb-0">
                                <label>Update Status (optional)</label>
                                <select name="status" class="form-control">
                                    <option value="">Keep Current ({{ ucfirst(str_replace('_', ' ', $ticket->status)) }})</option>
                                    <option value="in_progress">In Progress</option>
                                    <option value="waiting">Waiting for User</option>
                                    <option value="resolved">Resolved</option>
                                    <option value="closed">Closed</option>
                                </select>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane mr-1"></i>Send Reply
                            </button>
                        </div>
                    </form>
                </div>
            @else
                <div class="alert alert-secondary">
                    <i class="fas fa-lock mr-2"></i>
                    This ticket is closed.
                </div>
            @endif
        </div>

        <div class="col-md-4">
            <!-- Ticket Details -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-info-circle mr-2"></i>Ticket Details</h3>
                </div>
                <div class="card-body p-0">
                    <table class="table table-sm mb-0">
                        <tr>
                            <td class="text-muted">Ticket #</td>
                            <td><code>{{ $ticket->ticket_number }}</code></td>
                        </tr>
                        <tr>
                            <td class="text-muted">User</td>
                            <td>
                                <a href="{{ route('admin.users.show', $ticket->user) }}">
                                    {{ $ticket->user->name }}
                                </a>
                                <br><small>{{ $ticket->user->email }}</small>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Category</td>
                            <td>
                                <i class="{{ $ticket->category_icon }} mr-1"></i>
                                {{ ucfirst($ticket->category) }}
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Priority</td>
                            <td>
                                <span class="badge {{ $ticket->priority_badge }}">
                                    {{ ucfirst($ticket->priority) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Status</td>
                            <td>
                                <span class="badge {{ $ticket->status_badge }}">
                                    {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Created</td>
                            <td>{{ $ticket->created_at->format('M d, Y h:i A') }}</td>
                        </tr>
                        <tr>
                            <td class="text-muted">Assigned To</td>
                            <td>{{ $ticket->assignedTo?->name ?? 'Unassigned' }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-bolt mr-2"></i>Quick Actions</h3>
                </div>
                <div class="card-body">
                    @if(!$ticket->assigned_to)
                        <form action="{{ route('admin.support.assign', $ticket) }}" method="POST" class="mb-2">
                            @csrf
                            <button type="submit" class="btn btn-success btn-block">
                                <i class="fas fa-user-check mr-1"></i>Assign to Me
                            </button>
                        </form>
                    @endif

                    <form action="{{ route('admin.support.status', $ticket) }}" method="POST">
                        @csrf
                        <div class="input-group mb-2">
                            <select name="status" class="form-control">
                                <option value="open" {{ $ticket->status == 'open' ? 'selected' : '' }}>Open</option>
                                <option value="in_progress" {{ $ticket->status == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                                <option value="waiting" {{ $ticket->status == 'waiting' ? 'selected' : '' }}>Waiting</option>
                                <option value="resolved" {{ $ticket->status == 'resolved' ? 'selected' : '' }}>Resolved</option>
                                <option value="closed" {{ $ticket->status == 'closed' ? 'selected' : '' }}>Closed</option>
                            </select>
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <a href="{{ route('admin.support.index') }}" class="btn btn-outline-secondary btn-block">
                <i class="fas fa-arrow-left mr-1"></i>Back to Tickets
            </a>
        </div>
    </div>
@endsection
