@extends('layouts.admin')

@section('title', 'Failed Jobs')
@section('page-title', 'Failed Jobs')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Failed Jobs</li>
@endsection

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-exclamation-triangle text-danger mr-2"></i>Failed Jobs Queue</h3>
        </div>
        <div class="card-body p-0">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Queue</th>
                        <th>Exception</th>
                        <th>Failed At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($jobs as $job)
                        <tr>
                            <td>{{ $job->id }}</td>
                            <td><span class="badge badge-info">{{ $job->queue }}</span></td>
                            <td>
                                <small class="text-danger">{{ Str::limit($job->exception, 100) }}</small>
                            </td>
                            <td>{{ \Carbon\Carbon::parse($job->failed_at)->diffForHumans() }}</td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <form action="{{ route('admin.system.retry-job', $job->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-warning" title="Retry">
                                            <i class="fas fa-redo"></i>
                                        </button>
                                    </form>
                                    <form action="{{ route('admin.system.delete-job', $job->id) }}" method="POST" class="d-inline"
                                          onsubmit="return confirm('Delete this failed job?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger" title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center p-5">
                                <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                                <p class="text-muted mb-0">No failed jobs! Everything is running smoothly.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($jobs->hasPages())
            <div class="card-footer">
                {{ $jobs->links() }}
            </div>
        @endif
    </div>
@endsection
