@extends('layouts.admin')

@section('title', 'Upload Logs')
@section('page-title', 'Upload Logs')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Upload Logs</li>
@endsection

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-history mr-2"></i>Recent Upload Activity</h3>
        </div>
        <div class="card-body p-0">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>User</th>
                        <th>Video</th>
                        <th>Status</th>
                        <th>Message</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($logs as $log)
                        <tr>
                            <td>{{ $log->created_at->format('M d, H:i:s') }}</td>
                            <td>
                                @if($log->user)
                                    <a href="{{ route('admin.users.edit', $log->user) }}">
                                        {{ $log->user->name }}
                                    </a>
                                @else
                                    <span class="text-muted">Deleted</span>
                                @endif
                            </td>
                            <td>
                                @if($log->video)
                                    {{ Str::limit($log->video->title, 30) }}
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                <span class="badge {{ $log->status_badge }}">
                                    {{ ucfirst(str_replace('_', ' ', $log->status)) }}
                                </span>
                            </td>
                            <td>{{ Str::limit($log->message, 50) }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center p-5">
                                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                <p class="text-muted mb-0">No upload logs yet.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($logs->hasPages())
            <div class="card-footer">
                {{ $logs->links() }}
            </div>
        @endif
    </div>
@endsection
