@extends('layouts.auth')

@section('title', 'Register')

@section('content')
    <div class="auth-header">
        <h1>Create an account</h1>
        <p>Start automating your YouTube publishing today</p>
    </div>

    @if($errors->any())
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
                {{ $error }}<br>
            @endforeach
        </div>
    @endif

    <form action="{{ route('register') }}" method="POST">
        @csrf
        <div class="form-group">
            <label for="name">Full Name</label>
            <div class="input-wrapper">
                <i class="fas fa-user"></i>
                <input type="text" id="name" name="name" placeholder="John Doe" value="{{ old('name') }}" required autofocus>
            </div>
        </div>

        <div class="form-group">
            <label for="email">Email Address</label>
            <div class="input-wrapper">
                <i class="fas fa-envelope"></i>
                <input type="email" id="email" name="email" placeholder="you@example.com" value="{{ old('email') }}" required>
            </div>
        </div>

        <div class="form-group">
            <label for="password">Password</label>
            <div class="input-wrapper">
                <i class="fas fa-lock"></i>
                <input type="password" id="password" name="password" placeholder="••••••••" minlength="6" required>
            </div>
        </div>

        <div class="form-group">
            <label for="password_confirmation">Confirm Password</label>
            <div class="input-wrapper">
                <i class="fas fa-lock"></i>
                <input type="password" id="password_confirmation" name="password_confirmation" placeholder="••••••••" required>
            </div>
        </div>

        <div class="form-options">
            <div class="checkbox-wrapper">
                <input type="checkbox" id="terms" name="terms" required>
                <label for="terms">I agree to the Terms & Privacy Policy</label>
            </div>
        </div>

        <button type="submit" class="btn btn-primary">
            <i class="fas fa-rocket"></i> Create Account
        </button>
    </form>

    <div class="auth-footer">
        <p>Already have an account? <a href="{{ route('login') }}">Sign in</a></p>
    </div>
@endsection
