@extends('layouts.admin')

@section('title', 'Dashboard')
@section('page-title', 'Dashboard')

@section('breadcrumbs')
    <li class="breadcrumb-item active">Dashboard</li>
@endsection

@section('content')
    <!-- Stats Boxes -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-primary">
                <div class="inner">
                    <h3>{{ $todayUploads }}</h3>
                    <p>Today's Uploads</p>
                </div>
                <div class="icon">
                    <i class="fas fa-cloud-upload-alt"></i>
                </div>
                <a href="{{ route('schedules.index') }}" class="small-box-footer">
                    View Schedules <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>{{ $activeSchedules }}</h3>
                    <p>Active Schedules</p>
                </div>
                <div class="icon">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <a href="{{ route('schedules.create') }}" class="small-box-footer">
                    Create New <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3>{{ $pendingVideos }}</h3>
                    <p>Videos in Queue</p>
                </div>
                <div class="icon">
                    <i class="fas fa-video"></i>
                </div>
                <a href="{{ route('schedules.index') }}" class="small-box-footer">
                    View All <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>{{ $usedQuota }}/{{ $dailyLimit }}</h3>
                    <p>Daily Quota Used</p>
                </div>
                <div class="icon">
                    <i class="fas fa-chart-pie"></i>
                </div>
                <a href="#" class="small-box-footer">
                    {{ round(($usedQuota / max($dailyLimit, 1)) * 100) }}% Used
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Next Upload Card -->
        <div class="col-md-4">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-clock mr-2"></i>Next Upload</h3>
                </div>
                <div class="card-body text-center">
                    @if($nextUpload)
                        <h2 class="mb-0" id="countdown">
                            {{ $nextUpload->next_run_at->diffForHumans() }}
                        </h2>
                        <p class="text-muted mt-2">
                            {{ $nextUpload->next_run_at->format('M d, Y H:i') }}
                        </p>
                        <p>
                            <span class="badge badge-{{ $nextUpload->upload_mode === 'shorts' ? 'danger' : 'primary' }}">
                                {{ ucfirst($nextUpload->upload_mode) }}
                            </span>
                        </p>
                    @else
                        <p class="text-muted mb-0">
                            <i class="fas fa-info-circle"></i> No scheduled uploads
                        </p>
                        <a href="{{ route('schedules.create') }}" class="btn btn-primary mt-3">
                            Create Schedule
                        </a>
                    @endif
                </div>
            </div>

            <!-- Connected Accounts -->
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-plug mr-2"></i>Connected Accounts</h3>
                </div>
                <div class="card-body p-0">
                    @forelse(Auth::user()->socialAccounts as $account)
                        <div class="p-3 border-bottom d-flex align-items-center">
                            <i class="{{ $account->platform_icon }} fa-2x mr-3"></i>
                            <div>
                                <strong>{{ $account->platform_user_name }}</strong>
                                <br>
                                <small class="text-muted">{{ ucfirst($account->platform) }}</small>
                            </div>
                            @if($account->needs_reauth)
                                <span class="badge badge-warning ml-auto">Needs Reauth</span>
                            @endif
                        </div>
                    @empty
                        <div class="p-3 text-center text-muted">
                            <p>No accounts connected</p>
                            <a href="{{ route('accounts.index') }}" class="btn btn-sm btn-primary">
                                Connect Account
                            </a>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Recent Schedules -->
        <div class="col-md-8">
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-calendar-alt mr-2"></i>Recent Schedules</h3>
                    <div class="card-tools">
                        <a href="{{ route('schedules.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> New Schedule
                        </a>
                    </div>
                </div>
                <div class="card-body p-0">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Account</th>
                                <th>Progress</th>
                                <th>Status</th>
                                <th>Next Run</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($recentSchedules as $schedule)
                                <tr>
                                    <td>
                                        <a href="{{ route('schedules.show', $schedule) }}">
                                            {{ $schedule->name ?? 'Schedule #' . $schedule->id }}
                                        </a>
                                        @if($schedule->upload_mode === 'shorts')
                                            <span class="badge badge-danger">Shorts</span>
                                        @endif
                                    </td>
                                    <td>
                                        <i class="{{ $schedule->socialAccount->platform_icon }}"></i>
                                        {{ Str::limit($schedule->socialAccount->platform_user_name, 15) }}
                                    </td>
                                    <td>
                                        <div class="progress progress-sm">
                                            <div class="progress-bar bg-success" 
                                                 style="width: {{ $schedule->progress }}%"></div>
                                        </div>
                                        <small>{{ $schedule->videos->where('is_uploaded', true)->count() }}/{{ $schedule->videos->count() }}</small>
                                    </td>
                                    <td>
                                        <span class="badge {{ $schedule->status_badge }}">
                                            {{ ucfirst(str_replace('_', ' ', $schedule->status)) }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($schedule->next_run_at)
                                            {{ $schedule->next_run_at->diffForHumans() }}
                                        @elseif($schedule->resume_at)
                                            <small class="text-warning">Resumes {{ $schedule->resume_at->diffForHumans() }}</small>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted p-4">
                                        No schedules yet. <a href="{{ route('schedules.create') }}">Create your first schedule</a>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Recent Uploads -->
            <div class="card card-outline card-success">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-check-circle mr-2"></i>Recent Uploads</h3>
                </div>
                <div class="card-body p-0">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Video</th>
                                <th>Schedule</th>
                                <th>Uploaded</th>
                                <th>Link</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($recentUploads as $video)
                                <tr>
                                    <td>{{ Str::limit($video->title, 30) }}</td>
                                    <td>{{ $video->schedule->name ?? 'Schedule #' . $video->schedule_id }}</td>
                                    <td>{{ $video->uploaded_at->diffForHumans() }}</td>
                                    <td>
                                        @if($video->platform_video_id)
                                            <a href="{{ $video->youtube_url }}" target="_blank" class="btn btn-xs btn-danger">
                                                <i class="fab fa-youtube"></i> Watch
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center text-muted p-4">
                                        No videos uploaded yet
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
