@extends('install.layout')

@section('title', 'Admin Setup')
@section('step1-class', 'completed')
@section('step2-class', 'completed')
@section('step3-class', 'active')

@section('content')
    <h2><i class="fas fa-user-shield" style="color: #8b5cf6; margin-right: 10px;"></i>Admin Account</h2>
    <p style="color: rgba(255,255,255,0.7); margin-bottom: 25px;">
        Create your administrator account and configure your site.
    </p>
    
    <form action="{{ route('install.admin.save') }}" method="POST">
        @csrf
        
        <div class="form-group">
            <label for="site_name">Site Name</label>
            <input type="text" name="site_name" id="site_name" class="form-control" 
                   value="{{ old('site_name', 'Updit') }}" required>
        </div>
        
        <div class="form-group">
            <label for="site_url">Site URL</label>
            <input type="url" name="site_url" id="site_url" class="form-control" 
                   value="{{ old('site_url', url('/')) }}" placeholder="https://yourdomain.com" required>
        </div>
        
        <hr style="border-color: rgba(255,255,255,0.1); margin: 20px 0;">
        
        <div class="form-group">
            <label for="admin_name">Admin Name</label>
            <input type="text" name="admin_name" id="admin_name" class="form-control" 
                   value="{{ old('admin_name') }}" placeholder="John Doe" required>
        </div>
        
        <div class="form-group">
            <label for="admin_email">Admin Email</label>
            <input type="email" name="admin_email" id="admin_email" class="form-control" 
                   value="{{ old('admin_email') }}" placeholder="admin@example.com" required>
        </div>
        
        <div class="row">
            <div class="col">
                <div class="form-group">
                    <label for="admin_password">Password</label>
                    <input type="password" name="admin_password" id="admin_password" class="form-control" 
                           placeholder="Min 6 characters" required>
                </div>
            </div>
            <div class="col">
                <div class="form-group">
                    <label for="admin_password_confirmation">Confirm Password</label>
                    <input type="password" name="admin_password_confirmation" id="admin_password_confirmation" 
                           class="form-control" placeholder="Confirm password" required>
                </div>
            </div>
        </div>
        
        <button type="submit" class="btn btn-primary btn-block">
            <i class="fas fa-magic" style="margin-right: 10px;"></i> Install Updit
        </button>
    </form>
@endsection
