@extends('install.layout')

@section('title', 'Database Setup')
@section('step1-class', 'completed')
@section('step2-class', 'active')

@section('content')
    <h2><i class="fas fa-database" style="color: #8b5cf6; margin-right: 10px;"></i>Database Configuration</h2>
    <p style="color: rgba(255,255,255,0.7); margin-bottom: 25px;">
        Enter your MySQL database details. Create a database first in cPanel/phpMyAdmin.
    </p>
    
    <form action="{{ route('install.database.save') }}" method="POST">
        @csrf
        
        <div class="row">
            <div class="col">
                <div class="form-group">
                    <label for="db_host">Database Host</label>
                    <input type="text" name="db_host" id="db_host" class="form-control" 
                           value="{{ old('db_host', 'localhost') }}" required>
                </div>
            </div>
            <div class="col">
                <div class="form-group">
                    <label for="db_port">Port</label>
                    <input type="text" name="db_port" id="db_port" class="form-control" 
                           value="{{ old('db_port', '3306') }}" required>
                </div>
            </div>
        </div>
        
        <div class="form-group">
            <label for="db_database">Database Name</label>
            <input type="text" name="db_database" id="db_database" class="form-control" 
                   value="{{ old('db_database') }}" placeholder="e.g. updit_db" required>
        </div>
        
        <div class="form-group">
            <label for="db_username">Database Username</label>
            <input type="text" name="db_username" id="db_username" class="form-control" 
                   value="{{ old('db_username') }}" placeholder="e.g. root" required>
        </div>
        
        <div class="form-group">
            <label for="db_password">Database Password</label>
            <input type="password" name="db_password" id="db_password" class="form-control" 
                   placeholder="Leave empty if none">
        </div>
        
        <button type="submit" class="btn btn-primary btn-block">
            Test Connection & Continue <i class="fas fa-arrow-right" style="margin-left: 10px;"></i>
        </button>
    </form>
@endsection
