@extends('install.layout')

@section('title', 'Welcome')
@section('step1-class', 'active')

@section('content')
    <h2><i class="fas fa-rocket" style="color: #8b5cf6; margin-right: 10px;"></i>Welcome to Updit</h2>
    <p style="color: rgba(255,255,255,0.7); margin-bottom: 25px;">
        Before we begin, please make sure your server meets the following requirements.
    </p>
    
    <table class="requirements-table">
        @foreach($requirements as $req)
            <tr>
                <td>{{ $req['name'] }}</td>
                <td>{{ $req['current'] }}</td>
                <td>
                    @if($req['passed'])
                        <i class="fas fa-check-circle badge-success"></i>
                    @else
                        <i class="fas fa-times-circle badge-danger"></i>
                    @endif
                </td>
            </tr>
        @endforeach
    </table>
    
    @if($allPassed)
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> All requirements passed! You can proceed with the installation.
        </div>
        <a href="{{ route('install.database') }}" class="btn btn-primary btn-block">
            Continue <i class="fas fa-arrow-right" style="margin-left: 10px;"></i>
        </a>
    @else
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-triangle"></i> Some requirements are not met. Please fix them before continuing.
        </div>
        <button class="btn btn-primary btn-block" disabled>Continue</button>
    @endif
@endsection
