<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Auth') - Updit</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Poppins', sans-serif;
            min-height: 100vh;
            display: flex;
            background: #030014;
            color: #fff;
        }
        
        .auth-container {
            display: flex;
            width: 100%;
            min-height: 100vh;
        }
        
        /* Left Side - Branding */
        .auth-brand {
            flex: 1;
            background: linear-gradient(135deg, #1e1b4b 0%, #312e81 50%, #4c1d95 100%);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 60px;
            position: relative;
            overflow: hidden;
        }
        
        .auth-brand::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(139, 92, 246, 0.15) 0%, transparent 50%);
            animation: rotate 30s linear infinite;
        }
        
        @keyframes rotate {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
        
        .brand-content {
            position: relative;
            z-index: 1;
            text-align: center;
            max-width: 400px;
        }
        
        .brand-logo {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 30px;
        }
        
        .brand-logo-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #6366f1, #8b5cf6);
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }
        
        .brand-content h2 {
            font-size: 2rem;
            font-weight: 600;
            margin-bottom: 16px;
            line-height: 1.3;
        }
        
        .brand-content p {
            color: rgba(255,255,255,0.7);
            font-size: 1.1rem;
            line-height: 1.7;
            margin-bottom: 40px;
        }
        
        .brand-features {
            text-align: left;
        }
        
        .brand-feature {
            display: flex;
            align-items: center;
            gap: 16px;
            padding: 16px 0;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .brand-feature:last-child {
            border-bottom: none;
        }
        
        .brand-feature-icon {
            width: 44px;
            height: 44px;
            background: rgba(255,255,255,0.1);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #a5b4fc;
        }
        
        .brand-feature span {
            font-size: 0.95rem;
            color: rgba(255,255,255,0.8);
        }
        
        /* Right Side - Form */
        .auth-form-side {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 40px;
            background: #030014;
        }
        
        .auth-form-container {
            width: 100%;
            max-width: 420px;
        }
        
        .auth-header {
            margin-bottom: 40px;
        }
        
        .auth-header h1 {
            font-size: 2rem;
            font-weight: 600;
            margin-bottom: 8px;
        }
        
        .auth-header p {
            color: rgba(255,255,255,0.6);
        }
        
        .form-group {
            margin-bottom: 24px;
        }
        
        .form-group label {
            display: block;
            font-size: 0.9rem;
            font-weight: 500;
            margin-bottom: 8px;
            color: rgba(255,255,255,0.8);
        }
        
        .input-wrapper {
            position: relative;
        }
        
        .input-wrapper input {
            width: 100%;
            padding: 16px 20px;
            padding-left: 50px;
            background: rgba(255,255,255,0.05);
            border: 1px solid rgba(255,255,255,0.1);
            border-radius: 12px;
            color: #fff;
            font-size: 1rem;
            font-family: inherit;
            transition: all 0.3s;
        }
        
        .input-wrapper input:focus {
            outline: none;
            border-color: #8b5cf6;
            background: rgba(139, 92, 246, 0.1);
        }
        
        .input-wrapper input::placeholder {
            color: rgba(255,255,255,0.4);
        }
        
        .input-wrapper i {
            position: absolute;
            left: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: rgba(255,255,255,0.4);
        }
        
        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 24px;
        }
        
        .checkbox-wrapper {
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .checkbox-wrapper input[type="checkbox"] {
            width: 18px;
            height: 18px;
            accent-color: #8b5cf6;
        }
        
        .checkbox-wrapper label {
            font-size: 0.9rem;
            color: rgba(255,255,255,0.7);
        }
        
        .forgot-link {
            color: #a5b4fc;
            text-decoration: none;
            font-size: 0.9rem;
            transition: color 0.3s;
        }
        
        .forgot-link:hover {
            color: #8b5cf6;
        }
        
        .btn {
            width: 100%;
            padding: 16px;
            border-radius: 12px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            font-family: inherit;
            border: none;
            transition: all 0.3s;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #6366f1, #8b5cf6);
            color: #fff;
            box-shadow: 0 4px 20px rgba(139, 92, 246, 0.3);
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 30px rgba(139, 92, 246, 0.5);
        }
        
        .divider {
            display: flex;
            align-items: center;
            gap: 16px;
            margin: 30px 0;
        }
        
        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background: rgba(255,255,255,0.1);
        }
        
        .divider span {
            color: rgba(255,255,255,0.5);
            font-size: 0.85rem;
        }
        
        .auth-footer {
            text-align: center;
            margin-top: 30px;
            color: rgba(255,255,255,0.6);
            font-size: 0.95rem;
        }
        
        .auth-footer a {
            color: #a5b4fc;
            text-decoration: none;
            font-weight: 500;
        }
        
        .auth-footer a:hover {
            color: #8b5cf6;
        }
        
        .alert {
            padding: 14px 18px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-size: 0.9rem;
        }
        
        .alert-danger {
            background: rgba(239, 68, 68, 0.15);
            border: 1px solid rgba(239, 68, 68, 0.3);
            color: #fca5a5;
        }
        
        .alert-success {
            background: rgba(16, 185, 129, 0.15);
            border: 1px solid rgba(16, 185, 129, 0.3);
            color: #6ee7b7;
        }
        
        .back-home {
            position: absolute;
            top: 30px;
            left: 30px;
            color: rgba(255,255,255,0.6);
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 0.9rem;
            transition: color 0.3s;
        }
        
        .back-home:hover {
            color: #fff;
        }
        
        @media (max-width: 1024px) {
            .auth-brand {
                display: none;
            }
            
            .auth-form-side {
                padding: 30px;
            }
        }
    </style>
</head>
<body>
    <div class="auth-container">
        <div class="auth-brand">
            <a href="/" class="back-home">
                <i class="fas fa-arrow-left"></i> Back to Home
            </a>
            <div class="brand-content">
                <div class="brand-logo">
                    <div class="brand-logo-icon"><i class="fas fa-upload"></i></div>
                    <span>Updit</span>
                </div>
                <h2>Automate Your YouTube Publishing</h2>
                <p>Join thousands of creators who save hours every week with smart video scheduling.</p>
                <div class="brand-features">
                    <div class="brand-feature">
                        <div class="brand-feature-icon"><i class="fas fa-clock"></i></div>
                        <span>Smart scheduling with custom intervals</span>
                    </div>
                    <div class="brand-feature">
                        <div class="brand-feature-icon"><i class="fas fa-sync"></i></div>
                        <span>Auto-restart on quota limits</span>
                    </div>
                    <div class="brand-feature">
                        <div class="brand-feature-icon"><i class="fas fa-shield-alt"></i></div>
                        <span>Bank-level security for your data</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="auth-form-side">
            <div class="auth-form-container">
                @yield('content')
            </div>
        </div>
    </div>
</body>
</html>
