<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', 'Page') - Updit</title>
    <meta name="description" content="@yield('description', 'Updit - Automate your YouTube publishing')">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    
    <style>
        :root {
            --primary: #8b5cf6;
            --primary-dark: #7c3aed;
            --secondary: #6366f1;
            --dark: #0f0c29;
            --darker: #030014;
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: var(--darker);
            color: #fff;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        .container { max-width: 1200px; margin: 0 auto; padding: 0 24px; }
        
        /* Header */
        header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            padding: 16px 0;
            background: rgba(3, 0, 20, 0.95);
            backdrop-filter: blur(12px);
            border-bottom: 1px solid rgba(139, 92, 246, 0.1);
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            display: flex;
            align-items: center;
            font-size: 1.75rem;
            font-weight: 800;
            text-decoration: none;
            color: #fff;
            gap: 10px;
        }
        
        .logo-icon {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
        }
        
        .logo-text {
            background: linear-gradient(135deg, #fff 0%, #a5b4fc 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        nav {
            display: flex;
            gap: 32px;
            align-items: center;
        }
        
        nav a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            font-weight: 500;
            font-size: 0.95rem;
            transition: all 0.3s;
        }
        
        nav a:hover { color: #fff; }
        
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 28px;
            border-radius: 50px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
            font-size: 0.95rem;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            color: #fff;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 30px rgba(139, 92, 246, 0.5);
        }
        
        .btn-outline {
            background: transparent;
            border: 2px solid rgba(255,255,255,0.2);
            color: #fff;
        }
        
        /* Main Content */
        main {
            flex: 1;
            padding-top: 100px;
            padding-bottom: 60px;
        }
        
        .page-header {
            text-align: center;
            padding: 60px 0;
            background: radial-gradient(ellipse at top, rgba(139, 92, 246, 0.15) 0%, transparent 50%);
        }
        
        .page-header h1 {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 16px;
        }
        
        .page-header p {
            color: rgba(255,255,255,0.6);
            font-size: 1.1rem;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .page-content {
            padding: 60px 0;
        }
        
        .content-box {
            background: rgba(255,255,255,0.03);
            border: 1px solid rgba(255,255,255,0.08);
            border-radius: 20px;
            padding: 50px;
            max-width: 900px;
            margin: 0 auto;
        }
        
        .content-box h2 {
            font-size: 1.5rem;
            margin-bottom: 16px;
            color: var(--primary);
        }
        
        .content-box p, .content-box li {
            color: rgba(255,255,255,0.8);
            line-height: 1.8;
            margin-bottom: 16px;
        }
        
        .content-box ul {
            padding-left: 24px;
            margin-bottom: 24px;
        }
        
        /* Contact Form */
        .contact-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 50px;
        }
        
        .contact-info h3 {
            font-size: 1.25rem;
            margin-bottom: 24px;
        }
        
        .contact-item {
            display: flex;
            align-items: center;
            gap: 16px;
            margin-bottom: 20px;
        }
        
        .contact-item i {
            width: 50px;
            height: 50px;
            background: rgba(139, 92, 246, 0.2);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
            font-size: 1.2rem;
        }
        
        .contact-item span {
            color: rgba(255,255,255,0.8);
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: rgba(255,255,255,0.8);
        }
        
        .form-group input,
        .form-group textarea {
            width: 100%;
            padding: 14px 18px;
            background: rgba(255,255,255,0.05);
            border: 1px solid rgba(255,255,255,0.1);
            border-radius: 10px;
            color: #fff;
            font-family: inherit;
            font-size: 1rem;
        }
        
        .form-group input:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--primary);
        }
        
        .form-group textarea {
            min-height: 150px;
            resize: vertical;
        }
        
        /* Footer */
        footer {
            padding: 60px 0 30px;
            background: var(--darker);
            border-top: 1px solid rgba(255,255,255,0.05);
        }
        
        .footer-grid {
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr;
            gap: 50px;
            margin-bottom: 50px;
        }
        
        .footer-brand p {
            color: rgba(255,255,255,0.6);
            margin-top: 16px;
            font-size: 0.9rem;
            line-height: 1.7;
        }
        
        .footer-links h4 {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 20px;
        }
        
        .footer-links a {
            display: block;
            color: rgba(255,255,255,0.6);
            text-decoration: none;
            padding: 6px 0;
            font-size: 0.9rem;
            transition: color 0.3s;
        }
        
        .footer-links a:hover { color: var(--primary); }
        
        .social-links {
            display: flex;
            gap: 12px;
            margin-top: 20px;
        }
        
        .social-links a {
            width: 40px;
            height: 40px;
            background: rgba(255,255,255,0.05);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            transition: all 0.3s;
        }
        
        .social-links a:hover {
            background: var(--primary);
        }
        
        .footer-bottom {
            padding-top: 30px;
            border-top: 1px solid rgba(255,255,255,0.05);
            text-align: center;
        }
        
        .footer-bottom p {
            color: rgba(255,255,255,0.5);
            font-size: 0.85rem;
            margin-bottom: 8px;
        }
        
        .footer-bottom .designer {
            color: rgba(255,255,255,0.4);
            font-size: 0.8rem;
        }
        
        .footer-bottom .designer a {
            color: #10b981;
            text-decoration: none;
        }
        
        @media (max-width: 1024px) {
            .footer-grid { grid-template-columns: 1fr 1fr; }
            .contact-grid { grid-template-columns: 1fr; }
        }
        
        @media (max-width: 768px) {
            nav { display: none; }
            .page-header h1 { font-size: 2rem; }
            .content-box { padding: 30px; }
            .footer-grid { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <header>
        <div class="container header-content">
            <a href="/" class="logo">
                <div class="logo-icon"><i class="fas fa-upload"></i></div>
                <span class="logo-text">Updit</span>
            </a>
            <nav>
                <a href="/#features">Features</a>
                <a href="/#how-it-works">How It Works</a>
                <a href="/#pricing">Pricing</a>
                <a href="{{ route('login') }}" class="btn btn-outline">Login</a>
                <a href="{{ route('register') }}" class="btn btn-primary">Get Started</a>
            </nav>
        </div>
    </header>

    <main>
        @yield('content')
    </main>

    <footer>
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <a href="/" class="logo">
                        <div class="logo-icon"><i class="fas fa-upload"></i></div>
                        <span class="logo-text">Updit</span>
                    </a>
                    <p>Automate your YouTube publishing workflow. Upload once, schedule smart, and focus on what matters - creating great content.</p>
                    <div class="social-links">
                        <a href="#"><i class="fab fa-twitter"></i></a>
                        <a href="#"><i class="fab fa-facebook-f"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                        <a href="#"><i class="fab fa-youtube"></i></a>
                    </div>
                </div>
                <div class="footer-links">
                    <h4>Product</h4>
                    <a href="/#features">Features</a>
                    <a href="/#pricing">Pricing</a>
                    <a href="/#how-it-works">How It Works</a>
                </div>
                <div class="footer-links">
                    <h4>Company</h4>
                    <a href="/about">About Us</a>
                    <a href="/contact">Contact</a>
                    <a href="/blog">Blog</a>
                </div>
                <div class="footer-links">
                    <h4>Legal</h4>
                    <a href="/privacy">Privacy Policy</a>
                    <a href="/terms">Terms of Service</a>
                    <a href="/cookies">Cookie Policy</a>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; {{ date('Y') }} Updit. All rights reserved.</p>
                <p class="designer">Designed by <a href="https://wa.me/2349035026516" target="_blank">Ogasmantechs</a> | <a href="https://wa.me/2349035026516" target="_blank"><i class="fab fa-whatsapp"></i> +234 903 502 6516</a></p>
            </div>
        </div>
    </footer>
</body>
</html>
