@extends('layouts.front')

@section('title', 'About Us')
@section('description', 'Learn about Updit and our mission to help content creators automate their YouTube publishing.')

@section('content')
    <div class="page-header">
        <div class="container">
            <h1>About Us</h1>
            <p>Our mission is to help content creators save time and grow their audience</p>
        </div>
    </div>
    
    <div class="page-content">
        <div class="container">
            <div class="content-box">
                <h2>Our Story</h2>
                <p>{{ \App\Models\Setting::getValue('about_us', 'Updit was founded with a simple mission: to help content creators spend less time on repetitive tasks and more time creating amazing content.') }}</p>
                
                <h2>What We Do</h2>
                <p>We provide a powerful video scheduling platform that automates YouTube publishing. Whether you're a solo creator making videos in your bedroom or a media company managing multiple channels, Updit helps you work smarter, not harder.</p>
                
                <h2>Our Values</h2>
                <ul>
                    <li><strong>Simplicity</strong> - We believe powerful tools should be easy to use</li>
                    <li><strong>Reliability</strong> - Your videos get published on time, every time</li>
                    <li><strong>Security</strong> - Your data and credentials are protected with bank-level encryption</li>
                    <li><strong>Support</strong> - We're here to help you succeed</li>
                </ul>
                
                <h2>Our Team</h2>
                <p>We're a small team of passionate developers, designers, and content creators who understand the challenges of growing a YouTube channel. We built Updit because we needed it ourselves.</p>
                
                <p style="text-align: center; margin-top: 40px;">
                    <a href="/contact" class="btn btn-primary">Get in Touch</a>
                </p>
            </div>
        </div>
    </div>
@endsection
