@extends('layouts.front')

@section('title', 'Contact Us')
@section('description', 'Get in touch with Updit. We are here to help you with any questions or concerns.')

@section('content')
    <div class="page-header">
        <div class="container">
            <h1>Contact Us</h1>
            <p>We'd love to hear from you. Send us a message and we'll respond as soon as possible.</p>
        </div>
    </div>
    
    <div class="page-content">
        <div class="container">
            <div class="content-box">
                <div class="contact-grid">
                    <div class="contact-info">
                        <h3>Get in Touch</h3>
                        
                        <div class="contact-item">
                            <i class="fas fa-envelope"></i>
                            <span>{{ \App\Models\Setting::getValue('contact_email', 'hello@updit.com') }}</span>
                        </div>
                        
                        <div class="contact-item">
                            <i class="fas fa-phone"></i>
                            <span>{{ \App\Models\Setting::getValue('contact_phone', '+1 (555) 123-4567') }}</span>
                        </div>
                        
                        <div class="contact-item">
                            <i class="fab fa-whatsapp"></i>
                            <span>{{ \App\Models\Setting::getValue('whatsapp_number', '+234 903 502 6516') }}</span>
                        </div>
                        
                        <div class="contact-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <span>{{ \App\Models\Setting::getValue('contact_address', '123 Creator Street, San Francisco, CA') }}</span>
                        </div>
                        
                        <h3 style="margin-top: 40px;">Follow Us</h3>
                        <div class="social-links" style="margin-top: 16px;">
                            <a href="{{ \App\Models\Setting::getValue('social_twitter', '#') }}"><i class="fab fa-twitter"></i></a>
                            <a href="{{ \App\Models\Setting::getValue('social_facebook', '#') }}"><i class="fab fa-facebook-f"></i></a>
                            <a href="{{ \App\Models\Setting::getValue('social_instagram', '#') }}"><i class="fab fa-instagram"></i></a>
                            <a href="{{ \App\Models\Setting::getValue('social_youtube', '#') }}"><i class="fab fa-youtube"></i></a>
                        </div>
                    </div>
                    
                    <div class="contact-form">
                        <h3>Send a Message</h3>
                        
                        @if(session('success'))
                            <div style="background: rgba(16, 185, 129, 0.15); border: 1px solid rgba(16, 185, 129, 0.3); color: #6ee7b7; padding: 14px; border-radius: 10px; margin-bottom: 20px;">
                                {{ session('success') }}
                            </div>
                        @endif
                        
                        <form action="{{ route('contact.send') }}" method="POST">
                            @csrf
                            <div class="form-group">
                                <label for="name">Your Name</label>
                                <input type="text" id="name" name="name" required placeholder="John Doe">
                            </div>
                            
                            <div class="form-group">
                                <label for="email">Email Address</label>
                                <input type="email" id="email" name="email" required placeholder="you@example.com">
                            </div>
                            
                            <div class="form-group">
                                <label for="subject">Subject</label>
                                <input type="text" id="subject" name="subject" required placeholder="How can we help?">
                            </div>
                            
                            <div class="form-group">
                                <label for="message">Message</label>
                                <textarea id="message" name="message" required placeholder="Tell us more..."></textarea>
                            </div>
                            
                            <button type="submit" class="btn btn-primary" style="width: 100%;">
                                <i class="fas fa-paper-plane"></i> Send Message
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
