@extends('layouts.front')

@section('title', 'Cookie Policy')
@section('description', 'Learn about how Updit uses cookies and similar technologies.')

@section('content')
    <div class="page-header">
        <div class="container">
            <h1>Cookie Policy</h1>
            <p>Last updated: {{ date('F d, Y') }}</p>
        </div>
    </div>
    
    <div class="page-content">
        <div class="container">
            <div class="content-box">
                <h2>What Are Cookies?</h2>
                <p>Cookies are small text files stored on your device when you visit a website. They help websites remember your preferences and improve your experience.</p>
                
                <h2>How We Use Cookies</h2>
                <p>Updit uses cookies for the following purposes:</p>
                <ul>
                    <li><strong>Essential Cookies:</strong> Required for the website to function properly, including authentication and security.</li>
                    <li><strong>Session Cookies:</strong> Keep you logged in during your visit.</li>
                    <li><strong>Preference Cookies:</strong> Remember your settings and preferences.</li>
                    <li><strong>Analytics Cookies:</strong> Help us understand how visitors use our site.</li>
                </ul>
                
                <h2>Third-Party Cookies</h2>
                <p>We may use third-party services like Google Analytics that set their own cookies. These are governed by the respective third party's privacy policies.</p>
                
                <h2>Managing Cookies</h2>
                <p>You can control cookies through your browser settings. However, disabling cookies may affect the functionality of our website.</p>
                
                <h2>Contact Us</h2>
                <p>If you have questions about our use of cookies, please contact us at {{ \App\Models\Setting::getValue('contact_email', 'hello@updit.com') }}.</p>
            </div>
        </div>
    </div>
@endsection
