@extends('layouts.front')

@section('title', 'Privacy Policy')
@section('description', 'Read our privacy policy to understand how we collect, use, and protect your data.')

@section('content')
    <div class="page-header">
        <div class="container">
            <h1>Privacy Policy</h1>
            <p>Last updated: {{ date('F d, Y') }}</p>
        </div>
    </div>
    
    <div class="page-content">
        <div class="container">
            <div class="content-box">
                {!! nl2br(e(\App\Models\Setting::getValue('privacy', '
At Updit, we take your privacy seriously. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you use our service.

INFORMATION WE COLLECT

Personal Information: When you register for an account, we collect your name, email address, and password.

OAuth Data: When you connect your YouTube account, we receive an access token that allows us to upload videos on your behalf. We do not store your YouTube password.

Usage Data: We collect information about how you use our service, including upload schedules, video metadata, and platform preferences.

HOW WE USE YOUR INFORMATION

We use the information we collect to:
- Provide, maintain, and improve our services
- Process your video uploads and schedules
- Send you technical notices and support messages
- Respond to your comments and questions

DATA SECURITY

We implement appropriate technical and organizational security measures to protect your personal information. All OAuth tokens are encrypted at rest.

YOUR RIGHTS

You have the right to:
- Access your personal data
- Correct inaccurate data
- Delete your account and data
- Export your data

CONTACT US

If you have questions about this Privacy Policy, please contact us at ' . \App\Models\Setting::getValue('contact_email', 'hello@updit.com') . '.'))) !!}
            </div>
        </div>
    </div>
@endsection
