@extends('layouts.front')

@section('title', 'Terms of Service')
@section('description', 'Read our terms of service to understand your rights and responsibilities when using Updit.')

@section('content')
    <div class="page-header">
        <div class="container">
            <h1>Terms of Service</h1>
            <p>Last updated: {{ date('F d, Y') }}</p>
        </div>
    </div>
    
    <div class="page-content">
        <div class="container">
            <div class="content-box">
                {!! nl2br(e(\App\Models\Setting::getValue('terms', '
Welcome to Updit. By using our service, you agree to these Terms of Service.

1. ACCEPTANCE OF TERMS

By accessing or using Updit, you agree to be bound by these Terms. If you do not agree, do not use our service.

2. DESCRIPTION OF SERVICE

Updit provides a video scheduling platform that allows you to upload videos and schedule their publication to YouTube.

3. USER ACCOUNTS

You must register for an account to use our service. You are responsible for maintaining the security of your account credentials.

4. ACCEPTABLE USE

You agree not to:
- Upload content that violates YouTube\'s Terms of Service
- Use the service for any illegal purpose
- Attempt to gain unauthorized access to our systems
- Share your account with others

5. INTELLECTUAL PROPERTY

You retain all rights to your videos. We do not claim ownership of any content you upload.

6. LIMITATION OF LIABILITY

Updit is provided "as is" without warranties of any kind. We are not liable for any damages arising from your use of the service.

7. TERMINATION

We may terminate your account at any time for violations of these Terms. You may also delete your account at any time.

8. CHANGES TO TERMS

We may update these Terms from time to time. Continued use of the service constitutes acceptance of the new Terms.

9. CONTACT

If you have questions about these Terms, please contact us at ' . \App\Models\Setting::getValue('contact_email', 'hello@updit.com') . '.'))) !!}
            </div>
        </div>
    </div>
@endsection
