@extends('layouts.admin')

@section('title', 'My Profile')
@section('page-title', 'Profile Settings')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Profile</li>
@endsection

@section('content')
    <div class="row">
        <!-- Profile Info -->
        <div class="col-md-4">
            <div class="card card-primary card-outline">
                <div class="card-body box-profile">
                    <div class="text-center">
                        <div class="rounded-circle bg-gradient-primary d-inline-flex align-items-center justify-content-center" 
                             style="width: 100px; height: 100px; font-size: 2.5rem; color: white;">
                            {{ strtoupper(substr($user->name, 0, 1)) }}
                        </div>
                    </div>
                    <h3 class="profile-username text-center mt-3">{{ $user->name }}</h3>
                    <p class="text-muted text-center">{{ $user->email }}</p>
                    
                    <ul class="list-group list-group-unbordered mb-3">
                        <li class="list-group-item">
                            <b>Plan</b>
                            <span class="float-right badge badge-info">{{ $user->plan->name ?? 'Free' }}</span>
                        </li>
                        <li class="list-group-item">
                            <b>Member Since</b>
                            <span class="float-right">{{ $user->created_at->format('M Y') }}</span>
                        </li>
                        <li class="list-group-item">
                            <b>Total Videos</b>
                            <span class="float-right">{{ $stats['total_videos'] }}</span>
                        </li>
                        <li class="list-group-item">
                            <b>Uploaded</b>
                            <span class="float-right text-success">{{ $stats['uploaded_videos'] }}</span>
                        </li>
                        <li class="list-group-item">
                            <b>Active Schedules</b>
                            <span class="float-right">{{ $stats['active_schedules'] }}</span>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Connected Accounts -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-link mr-2"></i>Connected Accounts</h3>
                </div>
                <div class="card-body p-0">
                    @if($user->socialAccounts->count() > 0)
                        <ul class="list-group list-group-flush">
                            @foreach($user->socialAccounts as $account)
                                <li class="list-group-item d-flex justify-content-between">
                                    <span><i class="{{ $account->platform_icon }} mr-2"></i>{{ ucfirst($account->platform) }}</span>
                                    <span class="badge badge-success">Connected</span>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <p class="text-muted text-center py-3 mb-0">No accounts connected</p>
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('accounts.index') }}" class="btn btn-info btn-sm btn-block">
                        <i class="fas fa-plus mr-2"></i>Manage Accounts
                    </a>
                </div>
            </div>
        </div>

        <!-- Settings -->
        <div class="col-md-8">
            <!-- Update Profile -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-user mr-2"></i>Profile Information</h3>
                </div>
                <form action="{{ route('profile.update') }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="form-group">
                            <label for="name">Full Name</label>
                            <input type="text" name="name" id="name" class="form-control" 
                                   value="{{ old('name', $user->name) }}" required>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save mr-2"></i>Update Profile
                        </button>
                    </div>
                </form>
            </div>

            <!-- Update Email -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-envelope mr-2"></i>Change Email</h3>
                </div>
                <form action="{{ route('profile.email') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="form-group">
                            <label>Current Email</label>
                            <input type="email" class="form-control" value="{{ $user->email }}" disabled>
                        </div>
                        <div class="form-group">
                            <label for="email">New Email</label>
                            <input type="email" name="email" id="email" class="form-control" 
                                   placeholder="Enter new email" required>
                        </div>
                        <div class="form-group">
                            <label for="current_password_email">Current Password</label>
                            <input type="password" name="current_password" id="current_password_email" 
                                   class="form-control" placeholder="Confirm with your password" required>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-warning">
                            <i class="fas fa-envelope mr-2"></i>Change Email
                        </button>
                    </div>
                </form>
            </div>

            <!-- Update Password -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-lock mr-2"></i>Change Password</h3>
                </div>
                <form action="{{ route('profile.password') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="form-group">
                            <label for="current_password">Current Password</label>
                            <input type="password" name="current_password" id="current_password" 
                                   class="form-control" required>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="password">New Password</label>
                                    <input type="password" name="password" id="password" 
                                           class="form-control" minlength="6" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="password_confirmation">Confirm Password</label>
                                    <input type="password" name="password_confirmation" id="password_confirmation" 
                                           class="form-control" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-key mr-2"></i>Change Password
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
