@extends('layouts.admin')

@section('title', 'Schedules')
@section('page-title', 'My Schedules')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Schedules</li>
@endsection

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Schedules</h3>
            <div class="card-tools">
                <a href="{{ route('schedules.create') }}" class="btn btn-primary btn-sm">
                    <i class="fas fa-plus"></i> New Schedule
                </a>
            </div>
        </div>
        <div class="card-body p-0">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Account</th>
                        <th>Mode</th>
                        <th>Interval</th>
                        <th>Progress</th>
                        <th>Status</th>
                        <th>Next Run</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($schedules as $schedule)
                        <tr>
                            <td>
                                <a href="{{ route('schedules.show', $schedule) }}">
                                    {{ $schedule->name ?? 'Schedule #' . $schedule->id }}
                                </a>
                            </td>
                            <td>
                                <i class="{{ $schedule->socialAccount->platform_icon }}"></i>
                                {{ Str::limit($schedule->socialAccount->platform_user_name, 20) }}
                            </td>
                            <td>
                                <span class="badge badge-{{ $schedule->upload_mode === 'shorts' ? 'danger' : 'primary' }}">
                                    {{ ucfirst($schedule->upload_mode) }}
                                </span>
                            </td>
                            <td>{{ $schedule->interval_minutes }} min</td>
                            <td style="width: 150px;">
                                <div class="progress progress-sm">
                                    <div class="progress-bar bg-success" 
                                         style="width: {{ $schedule->progress }}%"></div>
                                </div>
                                <small>{{ $schedule->videos->where('is_uploaded', true)->count() }}/{{ $schedule->videos->count() }} videos</small>
                            </td>
                            <td>
                                <span class="badge {{ $schedule->status_badge }}">
                                    {{ ucfirst(str_replace('_', ' ', $schedule->status)) }}
                                </span>
                            </td>
                            <td>
                                @if($schedule->next_run_at)
                                    {{ $schedule->next_run_at->format('M d, H:i') }}
                                @elseif($schedule->resume_at)
                                    <small class="text-warning">
                                        Resumes {{ $schedule->resume_at->diffForHumans() }}
                                    </small>
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('schedules.show', $schedule) }}" class="btn btn-info" title="View">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    @if($schedule->status === 'active')
                                        <form action="{{ route('schedules.pause', $schedule) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-warning" title="Pause">
                                                <i class="fas fa-pause"></i>
                                            </button>
                                        </form>
                                    @elseif(in_array($schedule->status, ['paused', 'quota_limit']))
                                        <form action="{{ route('schedules.resume', $schedule) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-success" title="Resume">
                                                <i class="fas fa-play"></i>
                                            </button>
                                        </form>
                                    @endif
                                    <form action="{{ route('schedules.destroy', $schedule) }}" method="POST" class="d-inline"
                                          onsubmit="return confirm('Delete this schedule and all its videos?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger" title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center p-5">
                                <i class="fas fa-calendar-times fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No schedules found</p>
                                <a href="{{ route('schedules.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Create Your First Schedule
                                </a>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($schedules->hasPages())
            <div class="card-footer">
                {{ $schedules->links() }}
            </div>
        @endif
    </div>
@endsection
