@extends('layouts.admin')

@section('title', 'Subscription')
@section('page-title', 'Subscription & Billing')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Subscription</li>
@endsection

@section('content')
    <div class="row">
        <!-- Current Plan -->
        <div class="col-md-4">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-crown mr-2"></i>Current Plan</h3>
                </div>
                <div class="card-body text-center">
                    <h2 class="mb-0">{{ $user->plan->name ?? 'Free' }}</h2>
                    @if($user->plan && $user->plan->price > 0)
                        <p class="text-success">${{ number_format($user->plan->price, 2) }}/month</p>
                    @else
                        <p class="text-muted">Free Forever</p>
                    @endif
                    
                    @if($currentSubscription && $currentSubscription->ends_at)
                        <div class="alert alert-info mt-3">
                            <i class="fas fa-calendar mr-2"></i>
                            Renews: {{ $currentSubscription->ends_at->format('M d, Y') }}
                            <br>
                            <small>{{ $currentSubscription->daysRemaining() }} days remaining</small>
                        </div>
                    @endif

                    <hr>
                    
                    <ul class="list-unstyled text-left">
                        <li><i class="fas fa-check text-success mr-2"></i>{{ $user->plan->max_videos_per_batch ?? 5 }} videos per batch</li>
                        <li><i class="fas fa-check text-success mr-2"></i>{{ $user->plan->min_interval_minutes ?? 30 }} min interval</li>
                        <li><i class="fas fa-check text-success mr-2"></i>{{ $user->plan->daily_upload_cap ?? 10 }} daily uploads</li>
                    </ul>
                    
                    @if($currentSubscription)
                        <form action="{{ route('subscription.cancel') }}" method="POST" class="mt-3">
                            @csrf
                            <button type="submit" class="btn btn-outline-danger btn-sm"
                                    onclick="return confirm('Cancel subscription?')">
                                Cancel Subscription
                            </button>
                        </form>
                    @endif
                </div>
            </div>

            <!-- Payment History -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-history mr-2"></i>Payment History</h3>
                </div>
                <div class="card-body p-0">
                    @if($paymentHistory->count() > 0)
                        <table class="table table-sm mb-0">
                            @foreach($paymentHistory as $payment)
                                <tr>
                                    <td>
                                        <small>{{ $payment->created_at->format('M d, Y') }}</small>
                                        <br>{{ $payment->plan->name ?? 'N/A' }}
                                    </td>
                                    <td class="text-right">
                                        ${{ number_format($payment->amount, 2) }}
                                        <br>
                                        <span class="badge badge-{{ $payment->status_badge }}">
                                            {{ ucfirst($payment->status) }}
                                        </span>
                                    </td>
                                </tr>
                            @endforeach
                        </table>
                    @else
                        <p class="text-muted text-center py-3 mb-0">No payments yet</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Upgrade Options -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-gradient-primary">
                    <h3 class="card-title"><i class="fas fa-arrow-up mr-2"></i>Upgrade Your Plan</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($plans as $plan)
                            @if($plan->id !== $user->plan_id)
                                <div class="col-md-6 mb-3">
                                    <div class="card h-100 {{ $plan->price > 30 ? 'border-warning' : 'border-primary' }}">
                                        <div class="card-header text-center">
                                            <h4 class="mb-0">{{ $plan->name }}</h4>
                                            <h2 class="mt-2 mb-0">
                                                @if($plan->price > 0)
                                                    ${{ number_format($plan->price, 0) }}
                                                @else
                                                    Free
                                                @endif
                                            </h2>
                                            @if($plan->price > 0)
                                                <small class="text-muted">/month</small>
                                            @endif
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-unstyled">
                                                <li><i class="fas fa-video mr-2 text-primary"></i>{{ $plan->max_videos_per_batch }} videos/batch</li>
                                                <li><i class="fas fa-clock mr-2 text-primary"></i>{{ $plan->min_interval_minutes }} min interval</li>
                                                <li><i class="fas fa-upload mr-2 text-primary"></i>{{ $plan->daily_upload_cap }} daily uploads</li>
                                            </ul>
                                        </div>
                                        <div class="card-footer">
                                            @if($plan->price > 0)
                                                <button type="button" class="btn btn-primary btn-block" 
                                                        data-toggle="modal" data-target="#paymentModal-{{ $plan->id }}">
                                                    <i class="fas fa-credit-card mr-2"></i>Upgrade Now
                                                </button>
                                            @else
                                                <form action="{{ route('subscription.upgrade') }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="plan_id" value="{{ $plan->id }}">
                                                    <input type="hidden" name="payment_method" value="manual">
                                                    <button type="submit" class="btn btn-outline-secondary btn-block">
                                                        Downgrade to Free
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <!-- Payment Modal -->
                                @if($plan->price > 0)
                                    <div class="modal fade" id="paymentModal-{{ $plan->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header bg-gradient-primary">
                                                    <h5 class="modal-title">Upgrade to {{ $plan->name }}</h5>
                                                    <button type="button" class="close" data-dismiss="modal">
                                                        <span>&times;</span>
                                                    </button>
                                                </div>
                                                <form action="{{ route('subscription.upgrade') }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="plan_id" value="{{ $plan->id }}">
                                                    <div class="modal-body">
                                                        <h4 class="text-center mb-4">
                                                            Total: ${{ number_format($plan->price, 2) }}/month
                                                        </h4>
                                                        
                                                        <div class="form-group">
                                                            <label>Select Payment Method</label>
                                                            @foreach($gateways as $gateway)
                                                                <div class="custom-control custom-radio">
                                                                    <input type="radio" name="payment_method" 
                                                                           value="{{ $gateway->name }}" 
                                                                           id="gateway-{{ $plan->id }}-{{ $gateway->name }}"
                                                                           class="custom-control-input" required>
                                                                    <label class="custom-control-label" 
                                                                           for="gateway-{{ $plan->id }}-{{ $gateway->name }}">
                                                                        <i class="{{ $gateway->icon }} mr-2"></i>
                                                                        {{ $gateway->display_name }}
                                                                    </label>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                        <button type="submit" class="btn btn-primary">
                                                            <i class="fas fa-lock mr-2"></i>Continue to Payment
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endif
                        @endforeach
                    </div>

                    @if($gateways->isEmpty())
                        <div class="alert alert-warning text-center">
                            <i class="fas fa-exclamation-triangle mr-2"></i>
                            No payment methods are currently available. Please contact support.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
