@extends('layouts.app')

@section('title', 'New Ticket')
@section('page-title', 'Create Support Ticket')

@section('content')
    <div class="row">
        <div class="col-md-8">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-plus mr-2"></i>New Support Ticket</h3>
                </div>
                <form action="{{ route('support.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        @if($errors->any())
                            <div class="alert alert-danger">
                                @foreach($errors->all() as $error)
                                    {{ $error }}<br>
                                @endforeach
                            </div>
                        @endif

                        <div class="form-group">
                            <label for="subject">Subject <span class="text-danger">*</span></label>
                            <input type="text" name="subject" id="subject" class="form-control" 
                                   value="{{ old('subject') }}" placeholder="Brief description of your issue" required>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="category">Category <span class="text-danger">*</span></label>
                                    <select name="category" id="category" class="form-control" required>
                                        <option value="technical" {{ old('category') == 'technical' ? 'selected' : '' }}>
                                            🔧 Technical Issue
                                        </option>
                                        <option value="billing" {{ old('category') == 'billing' ? 'selected' : '' }}>
                                            💳 Billing / Payment
                                        </option>
                                        <option value="account" {{ old('category') == 'account' ? 'selected' : '' }}>
                                            👤 Account Issue
                                        </option>
                                        <option value="feature" {{ old('category') == 'feature' ? 'selected' : '' }}>
                                            💡 Feature Request
                                        </option>
                                        <option value="other" {{ old('category', 'other') == 'other' ? 'selected' : '' }}>
                                            ❓ Other
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="priority">Priority <span class="text-danger">*</span></label>
                                    <select name="priority" id="priority" class="form-control" required>
                                        <option value="low" {{ old('priority') == 'low' ? 'selected' : '' }}>Low</option>
                                        <option value="medium" {{ old('priority', 'medium') == 'medium' ? 'selected' : '' }}>Medium</option>
                                        <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>High</option>
                                        <option value="urgent" {{ old('priority') == 'urgent' ? 'selected' : '' }}>Urgent</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="message">Message <span class="text-danger">*</span></label>
                            <textarea name="message" id="message" class="form-control" rows="6" 
                                      placeholder="Describe your issue in detail..." required>{{ old('message') }}</textarea>
                            <small class="text-muted">Please provide as much detail as possible.</small>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-paper-plane mr-1"></i>Submit Ticket
                        </button>
                        <a href="{{ route('support.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card card-info">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-info-circle mr-2"></i>Before Submitting</h3>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="fas fa-check text-success mr-2"></i>
                            Check our <a href="#">FAQ</a> for common questions
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success mr-2"></i>
                            Provide specific error messages if any
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success mr-2"></i>
                            Include steps to reproduce the issue
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success mr-2"></i>
                            Mention which platform (YouTube, etc.)
                        </li>
                    </ul>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-clock mr-2"></i>Response Time</h3>
                </div>
                <div class="card-body">
                    <table class="table table-sm mb-0">
                        <tr>
                            <td><span class="badge badge-danger">Urgent</span></td>
                            <td>1-4 hours</td>
                        </tr>
                        <tr>
                            <td><span class="badge badge-warning">High</span></td>
                            <td>4-12 hours</td>
                        </tr>
                        <tr>
                            <td><span class="badge badge-info">Medium</span></td>
                            <td>12-24 hours</td>
                        </tr>
                        <tr>
                            <td><span class="badge badge-secondary">Low</span></td>
                            <td>24-48 hours</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
